/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.ManagementContextAware;
import org.mule.impl.endpoint.EndpointURIEndpointBuilder;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.springframework.beans.factory.FactoryBean;

public class EndpointFactoryBean
extends EndpointURIEndpointBuilder
implements FactoryBean,
ManagementContextAware,
Initialisable {
    public static final String ALWAYS_CREATE_STRING = "ALWAYS_CREATE";
    public static final String NEVER_CREATE_STRING = "NEVER_CREATE";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String type;
    private String createConnectorAsString;

    public Object getObject() throws Exception {
        if ("receiver".equals(this.type)) {
            this.logger.debug((Object)"Endpont type is \"receiver\", building inbound endpoint");
            return this.buildInboundEndpoint();
        }
        if ("sender".equals(this.type)) {
            this.logger.debug((Object)"Endpont type is \"sender\", building inbound endpoint");
            return this.buildOutboundEndpoint();
        }
        if ("response".equals(this.type)) {
            this.logger.debug((Object)"Endpont type is \"response\", building inbound endpoint");
            return this.buildResponseEndpoint();
        }
        throw new IllegalArgumentException("The endpoint type: " + this.type + "is not recognized.");
    }

    public Class getObjectType() {
        return UMOImmutableEndpoint.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void initialise() throws InitialisationException {
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCreateConnectorAsString(String createConnectorAsString) {
        this.createConnectorAsString = createConnectorAsString;
    }

    protected int getCreateConnector() {
        if (ALWAYS_CREATE_STRING.equals(this.createConnectorAsString)) {
            return 1;
        }
        if (NEVER_CREATE_STRING.equals(this.createConnectorAsString)) {
            return 2;
        }
        return 0;
    }
}

