/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.io.IOException;
import org.mule.config.spring.MissingParserProblemReporter;
import org.mule.config.spring.MuleBeanDefinitionDocumentReader;
import org.mule.registry.Registry;
import org.mule.umo.UMOManagementContext;
import org.mule.util.ClassUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;

public class MuleApplicationContext
extends AbstractXmlApplicationContext {
    public static final String LEGACY_BEAN_READER_CLASS = "org.mule.config.spring.MuleBeanDefinitionReader";
    private final Resource[] configResources;
    private final String[] configLocations;

    public MuleApplicationContext(Resource[] configResources) {
        this(configResources, true);
    }

    public MuleApplicationContext(Resource[] configResources, ApplicationContext parent) {
        super(parent);
        this.configResources = configResources;
        this.configLocations = null;
        this.refresh();
    }

    public MuleApplicationContext(Resource[] configResources, boolean refresh) throws BeansException {
        this.configResources = configResources;
        this.configLocations = null;
        if (refresh) {
            this.refresh();
        }
    }

    public MuleApplicationContext(String[] configLocations) {
        this(configLocations, true);
    }

    public MuleApplicationContext(String[] configLocations, ApplicationContext parent) {
        super(parent);
        this.configLocations = configLocations;
        this.configResources = null;
        this.refresh();
    }

    public MuleApplicationContext(String[] configLocations, boolean refresh) throws BeansException {
        this.configLocations = configLocations;
        this.configResources = null;
        if (refresh) {
            this.refresh();
        }
    }

    protected Resource[] getConfigResources() {
        return this.configResources;
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        XmlBeanDefinitionReader beanDefinitionReader;
        if (ClassUtils.isClassOnPath(LEGACY_BEAN_READER_CLASS, ((Object)((Object)this)).getClass())) {
            try {
                beanDefinitionReader = (XmlBeanDefinitionReader)ClassUtils.instanciateClass(LEGACY_BEAN_READER_CLASS, new Object[]{beanFactory, this.configLocations});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        }
        beanDefinitionReader.setDocumentReaderClass(MuleBeanDefinitionDocumentReader.class);
        beanDefinitionReader.setProblemReporter((ProblemReporter)new MissingParserProblemReporter());
        beanDefinitionReader.loadBeanDefinitions(this.configLocations);
    }

    public UMOManagementContext getManagementContext() {
        return (UMOManagementContext)this.getBeanFactory().getBean("_muleManagementContext");
    }

    public Registry getRegistry() {
        return (Registry)this.getBeanFactory().getBean("_muleRegistry");
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        DefaultListableBeanFactory bf = super.createBeanFactory();
        if (this.getParent() != null) {
            AbstractBeanFactory beanFactory = (AbstractBeanFactory)this.getParent().getAutowireCapableBeanFactory();
            bf.copyConfigurationFrom((ConfigurableBeanFactory)beanFactory);
        }
        return bf;
    }
}

