/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueManager;

public class QueueProfile {
    private int maxOutstandingMessages = 0;
    private boolean persistent = false;

    public QueueProfile() {
    }

    public QueueProfile(int maxOutstandingMessages, boolean persistent) {
        this.maxOutstandingMessages = maxOutstandingMessages;
        this.persistent = persistent;
    }

    public QueueProfile(QueueProfile queueProfile) {
        this.maxOutstandingMessages = queueProfile.getMaxOutstandingMessages();
        this.persistent = queueProfile.isPersistent();
    }

    public int getMaxOutstandingMessages() {
        return this.maxOutstandingMessages;
    }

    public void setMaxOutstandingMessages(int maxOutstandingMessages) {
        this.maxOutstandingMessages = maxOutstandingMessages;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void configureQueue(String component, QueueManager queueManager) throws InitialisationException {
        QueueConfiguration qc = new QueueConfiguration(this.maxOutstandingMessages, this.persistent);
        queueManager.setQueueConfiguration(component, qc);
    }

    public String toString() {
        return "QueueProfile{maxOutstandingMessage=" + this.maxOutstandingMessages + ", persistent=" + this.persistent + "}";
    }
}

