/*
 * Decompiled with CFR 0.152.
 */
package org.mule.components.builder;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.components.builder.MessageBuilder;
import org.mule.config.ConfigurationException;
import org.mule.impl.MuleMessage;
import org.mule.impl.UMOComponentAware;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.util.StringMessageUtils;

public abstract class AbstractMessageBuilder
implements UMOComponentAware,
Callable,
MessageBuilder {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected UMOComponent component;

    public void setComponent(UMOComponent component) throws ConfigurationException {
        this.component = component;
    }

    public Object onCall(UMOEventContext eventContext) throws Exception {
        MuleMessage requestMessage = new MuleMessage(eventContext.getTransformedMessage(), eventContext.getMessage());
        UMOMessage responseMessage = null;
        if (this.component.getOutboundRouter().hasEndpoints()) {
            ArrayList endpoints = new ArrayList();
            Iterator iterator = this.component.getOutboundRouter().getRouters().iterator();
            while (iterator.hasNext()) {
                UMOOutboundRouter router = (UMOOutboundRouter)iterator.next();
                endpoints.addAll(router.getEndpoints());
            }
            iterator = endpoints.iterator();
            while (iterator.hasNext()) {
                UMOImmutableEndpoint endpoint = (UMOImmutableEndpoint)iterator.next();
                Object request = requestMessage.getPayload();
                boolean rsync = eventContext.getMessage().getBooleanProperty("MULE_REMOTE_SYNC", endpoint.isRemoteSync());
                if (!rsync) {
                    this.logger.info((Object)("Endpoint: " + endpoint + " is not remoteSync enabled. Message builder finishing"));
                    if (eventContext.isSynchronous()) {
                        responseMessage = eventContext.sendEvent((UMOMessage)requestMessage, endpoint);
                    } else {
                        eventContext.dispatchEvent((UMOMessage)requestMessage, endpoint);
                        responseMessage = null;
                    }
                    break;
                }
                responseMessage = eventContext.sendEvent((UMOMessage)requestMessage, endpoint);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Response Message Received from: " + endpoint.getEndpointURI()));
                }
                if (this.logger.isTraceEnabled()) {
                    try {
                        this.logger.trace((Object)("Message Payload: \n" + StringMessageUtils.truncate(StringMessageUtils.toString(responseMessage.getPayload()), 200, false)));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                Object builtMessage = this.buildMessage(new MuleMessage(request, requestMessage), responseMessage);
                responseMessage = new MuleMessage(builtMessage, responseMessage);
                requestMessage = new MuleMessage(responseMessage.getPayload(), responseMessage);
            }
        } else {
            this.logger.info((Object)("There are currently no endpoints configured on component: " + this.component.getName()));
        }
        eventContext.setStopFurtherProcessing(true);
        return responseMessage;
    }
}

