/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.service;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.impl.MuleSessionHandler;
import org.mule.impl.endpoint.EndpointBuilder;
import org.mule.impl.endpoint.UrlEndpointBuilder;
import org.mule.providers.NullPayload;
import org.mule.providers.service.TransportFactory;
import org.mule.providers.service.TransportFactoryException;
import org.mule.providers.service.TransportServiceException;
import org.mule.providers.service.TransportServiceFinder;
import org.mule.transaction.XaTransactionFactory;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOTransactionFactory;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageDispatcherFactory;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.provider.UMOSessionHandler;
import org.mule.umo.provider.UMOStreamMessageAdapter;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;
import org.mule.util.ObjectFactory;
import org.mule.util.StringUtils;

public class TransportServiceDescriptor {
    protected static final Log logger = LogFactory.getLog((Class)TransportServiceDescriptor.class);
    private String protocol;
    private String serviceLocation;
    private String serviceError;
    private String serviceFinder;
    private String connector;
    private String connectorFactory;
    private String dispatcherFactory;
    private String transactionFactory;
    private String messageAdapter;
    private String streamMessageAdapter;
    private String messageReceiver;
    private String transactedMessageReceiver;
    private String xaTransactedMessageReceiver;
    private String endpointBuilder;
    private String sessionHandler;
    private String defaultInboundTransformer;
    private String defaultOutboundTransformer;
    private String defaultResponseTransformer;
    private Properties properties;
    private UMOTransformer inboundTransformer;
    private UMOTransformer outboundTransformer;
    private UMOTransformer responseTransformer;
    private TransportServiceFinder transportServiceFinder;

    public TransportServiceDescriptor(String protocol, String serviceLocation, Properties props) {
        this.protocol = protocol;
        this.serviceLocation = serviceLocation;
        this.properties = props;
        this.serviceError = this.removeProperty("service.error");
        this.connector = this.removeProperty("connector");
        this.connectorFactory = this.removeProperty("connector.factory");
        this.dispatcherFactory = this.removeProperty("dispatcher.factory");
        this.transactionFactory = this.removeProperty("transaction.factory");
        this.messageReceiver = this.removeProperty("message.receiver");
        this.transactedMessageReceiver = this.removeProperty("transacted.message.receiver");
        this.xaTransactedMessageReceiver = this.removeProperty("xa.transacted.message.receiver");
        this.messageAdapter = this.removeProperty("message.adapter");
        this.streamMessageAdapter = this.removeProperty("stream.message.adapter");
        this.defaultInboundTransformer = this.removeProperty("inbound.transformer");
        this.defaultOutboundTransformer = this.removeProperty("outbound.transformer");
        this.defaultResponseTransformer = this.removeProperty("response.transformer");
        this.endpointBuilder = this.removeProperty("endpoint.builder");
        this.serviceFinder = this.removeProperty("service.finder");
        this.sessionHandler = this.removeProperty("session.handler");
    }

    protected void setOverrides(Properties props) {
        if (props == null || props.size() == 0) {
            return;
        }
        this.serviceError = props.getProperty("service.error", this.serviceError);
        this.connector = props.getProperty("connector", this.connector);
        this.connectorFactory = props.getProperty("connector.factory", this.connectorFactory);
        this.dispatcherFactory = props.getProperty("dispatcher.factory", this.dispatcherFactory);
        this.messageReceiver = props.getProperty("message.receiver", this.messageReceiver);
        this.transactedMessageReceiver = props.getProperty("transacted.message.receiver", this.transactedMessageReceiver);
        this.xaTransactedMessageReceiver = props.getProperty("xa.transacted.message.receiver", this.xaTransactedMessageReceiver);
        this.messageAdapter = props.getProperty("message.adapter", this.messageAdapter);
        String temp = props.getProperty("inbound.transformer");
        if (temp != null) {
            this.defaultInboundTransformer = temp;
            this.inboundTransformer = null;
        }
        if ((temp = props.getProperty("outbound.transformer")) != null) {
            this.defaultOutboundTransformer = temp;
            this.outboundTransformer = null;
        }
        if ((temp = props.getProperty("response.transformer")) != null) {
            this.defaultResponseTransformer = temp;
            this.responseTransformer = null;
        }
        if ((temp = props.getProperty("endpoint.builder")) != null) {
            this.endpointBuilder = temp;
        }
        if ((temp = props.getProperty("service.finder")) != null) {
            this.serviceFinder = temp;
            this.transportServiceFinder = null;
        }
    }

    private String removeProperty(String name) {
        String temp = (String)this.properties.remove(name);
        if (StringUtils.isEmpty((String)StringUtils.trim((String)temp))) {
            return null;
        }
        return temp;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getServiceLocation() {
        return this.serviceLocation;
    }

    public String getServiceError() {
        return this.serviceError;
    }

    public String getConnector() {
        return this.connector;
    }

    public String getConnectorFactory() {
        return this.connectorFactory;
    }

    public String getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    public String getMessageReceiver() {
        return this.messageReceiver;
    }

    public String getTransactedMessageReceiver() {
        return this.transactedMessageReceiver;
    }

    public String getXaTransactedMessageReceiver() {
        return this.xaTransactedMessageReceiver;
    }

    public String getDefaultInboundTransformer() {
        return this.defaultInboundTransformer;
    }

    public String getDefaultOutboundTransformer() {
        return this.defaultOutboundTransformer;
    }

    public String getMessageAdapter() {
        return this.messageAdapter;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getEndpointBuilder() {
        return this.endpointBuilder;
    }

    public String getServiceFinder() {
        return this.serviceFinder;
    }

    public String getStreamMessageAdapter() {
        return this.streamMessageAdapter;
    }

    public String getTransactionFactory() {
        return this.transactionFactory;
    }

    public TransportServiceFinder getConnectorServiceFinder() {
        return this.transportServiceFinder;
    }

    public String getSessionHandler() {
        return this.sessionHandler;
    }

    public TransportServiceFinder createServiceFinder() throws TransportServiceException {
        if (this.serviceFinder == null) {
            return null;
        }
        if (this.transportServiceFinder == null) {
            try {
                this.transportServiceFinder = (TransportServiceFinder)ClassUtils.instanciateClass(this.serviceFinder, ClassUtils.NO_ARGS);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.cannotInstanciateFinder(this.serviceFinder), (Throwable)e);
            }
        }
        return this.transportServiceFinder;
    }

    public String getDefaultResponseTransformer() {
        return this.defaultResponseTransformer;
    }

    public UMOMessageAdapter createMessageAdapter(Object message) throws TransportServiceException {
        return this.createMessageAdapter(message, this.messageAdapter);
    }

    public UMOStreamMessageAdapter createStreamMessageAdapter(InputStream in, OutputStream out) throws TransportServiceException {
        if (this.getStreamMessageAdapter() == null) {
            throw new TransportServiceException(CoreMessages.objectNotSetInService("stream.message.adapter", this.getProtocol() + " service descriptor"));
        }
        try {
            if (out == null) {
                return (UMOStreamMessageAdapter)ClassUtils.instanciateClass(this.streamMessageAdapter, new Object[]{in});
            }
            return (UMOStreamMessageAdapter)ClassUtils.instanciateClass(this.streamMessageAdapter, new Object[]{in, out});
        }
        catch (Exception e) {
            throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Adapter", this.streamMessageAdapter), (Throwable)e);
        }
    }

    protected UMOMessageAdapter createMessageAdapter(Object message, String clazz) throws TransportServiceException {
        if (message == null) {
            message = NullPayload.getInstance();
        }
        if (this.messageAdapter != null) {
            try {
                return (UMOMessageAdapter)ClassUtils.instanciateClass(clazz, new Object[]{message});
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Adapter", clazz), (Throwable)e);
            }
        }
        throw new TransportServiceException(CoreMessages.objectNotSetInService("Message Adapter", this.getProtocol()));
    }

    public UMOSessionHandler createSessionHandler() throws TransportServiceException {
        if (this.getSessionHandler() == null) {
            this.sessionHandler = MuleSessionHandler.class.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No session.handler set in service description, defaulting to: " + this.sessionHandler));
            }
        }
        try {
            return (UMOSessionHandler)ClassUtils.instanciateClass(this.getSessionHandler(), ClassUtils.NO_ARGS, this.getClass());
        }
        catch (Throwable e) {
            throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("SessionHandler", this.sessionHandler), e);
        }
    }

    public UMOMessageReceiver createMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws UMOException {
        return this.createMessageReceiver(connector, component, endpoint, null);
    }

    public UMOMessageReceiver createMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, Object[] args) throws UMOException {
        String receiverClass = this.messageReceiver;
        if (endpoint.getTransactionConfig() != null && endpoint.getTransactionConfig().getAction() != 0) {
            boolean xaTx = endpoint.getTransactionConfig().getFactory() instanceof XaTransactionFactory;
            if (this.transactedMessageReceiver != null && !xaTx) {
                receiverClass = this.transactedMessageReceiver;
            } else if (this.xaTransactedMessageReceiver != null && xaTx) {
                receiverClass = this.xaTransactedMessageReceiver;
            }
        }
        if (receiverClass != null) {
            Object[] newArgs = args != null && args.length != 0 ? new Object[3 + args.length] : new Object[]{connector, component, endpoint};
            if (args != null && args.length != 0) {
                System.arraycopy(args, 0, newArgs, 3, newArgs.length - 3);
            }
            try {
                return (UMOMessageReceiver)ClassUtils.instanciateClass(receiverClass, newArgs);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Receiver", this.getProtocol()), (Throwable)e);
            }
        }
        throw new TransportServiceException(CoreMessages.objectNotSetInService("Message Receiver", this.getProtocol()));
    }

    public UMOMessageDispatcherFactory createDispatcherFactory() throws TransportServiceException {
        if (this.dispatcherFactory != null) {
            try {
                return (UMOMessageDispatcherFactory)ClassUtils.instanciateClass(this.dispatcherFactory, ClassUtils.NO_ARGS);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Message Dispatcher Factory", this.dispatcherFactory), (Throwable)e);
            }
        }
        throw new TransportServiceException(CoreMessages.objectNotSetInService("Message Dispatcher Factory", this.getProtocol()));
    }

    public UMOTransactionFactory createTransactionFactory() throws TransportServiceException {
        if (this.transactionFactory != null) {
            try {
                return (UMOTransactionFactory)ClassUtils.instanciateClass(this.transactionFactory, ClassUtils.NO_ARGS);
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Transaction Factory", this.transactionFactory), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public UMOConnector createConnector(String protocol) throws TransportServiceException {
        void var2_5;
        block7: {
            if (this.getServiceError() != null) {
                throw new TransportServiceException(MessageFactory.createStaticMessage(this.getServiceError()));
            }
            try {
                UMOConnector connector;
                if (this.getConnectorFactory() != null) {
                    ObjectFactory factory = (ObjectFactory)ClassUtils.loadClass(this.getConnectorFactory(), TransportFactory.class).newInstance();
                    connector = (UMOConnector)factory.create();
                    break block7;
                }
                if (this.getConnector() != null) {
                    connector = (UMOConnector)ClassUtils.loadClass(this.getConnector(), TransportFactory.class).newInstance();
                    break block7;
                }
                throw new TransportServiceException(CoreMessages.objectNotSetInService("Connector", this.getProtocol()));
            }
            catch (TransportServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TransportServiceException(CoreMessages.failedToCreateObjectWith("Connector", this.getConnector()), (Throwable)e);
            }
        }
        if (var2_5.getName() == null) {
            var2_5.setName("_" + protocol + "Connector#" + var2_5.hashCode());
        }
        return var2_5;
    }

    public UMOTransformer createInboundTransformer() throws TransportFactoryException {
        if (this.inboundTransformer != null) {
            return this.inboundTransformer;
        }
        if (this.getDefaultInboundTransformer() != null) {
            logger.info((Object)("Loading default inbound transformer: " + this.getDefaultInboundTransformer()));
            try {
                this.inboundTransformer = (UMOTransformer)ClassUtils.instanciateClass(this.getDefaultInboundTransformer(), ClassUtils.NO_ARGS);
                return this.inboundTransformer;
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("inbound", this.getDefaultInboundTransformer()), (Throwable)e);
            }
        }
        return null;
    }

    public UMOTransformer createNewInboundTransformer() throws TransportFactoryException {
        if (this.getDefaultInboundTransformer() != null) {
            logger.info((Object)("Loading default inbound transformer: " + this.getDefaultInboundTransformer()));
            try {
                this.inboundTransformer = (UMOTransformer)ClassUtils.instanciateClass(this.getDefaultInboundTransformer(), ClassUtils.NO_ARGS);
                return this.inboundTransformer;
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("inbound", this.getDefaultInboundTransformer()), (Throwable)e);
            }
        }
        return null;
    }

    public UMOTransformer createOutboundTransformer() throws TransportFactoryException {
        if (this.outboundTransformer != null) {
            return this.outboundTransformer;
        }
        if (this.getDefaultOutboundTransformer() != null) {
            logger.info((Object)("Loading default outbound transformer: " + this.getDefaultOutboundTransformer()));
            try {
                this.outboundTransformer = (UMOTransformer)ClassUtils.instanciateClass(this.getDefaultOutboundTransformer(), ClassUtils.NO_ARGS);
                return this.outboundTransformer;
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("outbound", this.getDefaultOutboundTransformer()), (Throwable)e);
            }
        }
        return null;
    }

    public UMOTransformer createNewOutboundTransformer() throws TransportFactoryException {
        if (this.getDefaultOutboundTransformer() != null) {
            logger.info((Object)("Loading default outbound transformer: " + this.getDefaultOutboundTransformer()));
            try {
                this.outboundTransformer = (UMOTransformer)ClassUtils.instanciateClass(this.getDefaultOutboundTransformer(), ClassUtils.NO_ARGS);
                return this.outboundTransformer;
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("outbound", this.getDefaultOutboundTransformer()), (Throwable)e);
            }
        }
        return null;
    }

    public UMOTransformer createResponseTransformer() throws TransportFactoryException {
        if (this.responseTransformer != null) {
            return this.responseTransformer;
        }
        if (this.getDefaultResponseTransformer() != null) {
            logger.info((Object)("Loading default response transformer: " + this.getDefaultResponseTransformer()));
            try {
                this.responseTransformer = (UMOTransformer)ClassUtils.instanciateClass(this.getDefaultResponseTransformer(), ClassUtils.NO_ARGS);
                return this.responseTransformer;
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("response", this.getDefaultResponseTransformer()), (Throwable)e);
            }
        }
        return null;
    }

    public UMOTransformer createNewResponseTransformer() throws TransportFactoryException {
        if (this.getDefaultResponseTransformer() != null) {
            logger.info((Object)("Loading default response transformer: " + this.getDefaultResponseTransformer()));
            try {
                this.responseTransformer = (UMOTransformer)ClassUtils.instanciateClass(this.getDefaultResponseTransformer(), ClassUtils.NO_ARGS);
                return this.responseTransformer;
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToLoadTransformer("response", this.getDefaultResponseTransformer()), (Throwable)e);
            }
        }
        return null;
    }

    public EndpointBuilder createEndpointBuilder() throws TransportFactoryException {
        if (this.endpointBuilder == null) {
            logger.debug((Object)("Endpoint resolver not set, Loading default resolver: " + UrlEndpointBuilder.class.getName()));
            return new UrlEndpointBuilder();
        }
        logger.debug((Object)("Loading endpointUri resolver: " + this.getEndpointBuilder()));
        try {
            return (EndpointBuilder)ClassUtils.instanciateClass(this.getEndpointBuilder(), ClassUtils.NO_ARGS);
        }
        catch (Exception e) {
            throw new TransportFactoryException(CoreMessages.failedToLoad("Endpoint Builder: " + this.getEndpointBuilder()), (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransportServiceDescriptor)) {
            return false;
        }
        TransportServiceDescriptor transportServiceDescriptor = (TransportServiceDescriptor)o;
        if (this.connector != null ? !this.connector.equals(transportServiceDescriptor.connector) : transportServiceDescriptor.connector != null) {
            return false;
        }
        if (this.connectorFactory != null ? !this.connectorFactory.equals(transportServiceDescriptor.connectorFactory) : transportServiceDescriptor.connectorFactory != null) {
            return false;
        }
        if (this.defaultInboundTransformer != null ? !this.defaultInboundTransformer.equals(transportServiceDescriptor.defaultInboundTransformer) : transportServiceDescriptor.defaultInboundTransformer != null) {
            return false;
        }
        if (this.defaultOutboundTransformer != null ? !this.defaultOutboundTransformer.equals(transportServiceDescriptor.defaultOutboundTransformer) : transportServiceDescriptor.defaultOutboundTransformer != null) {
            return false;
        }
        if (this.defaultResponseTransformer != null ? !this.defaultResponseTransformer.equals(transportServiceDescriptor.defaultResponseTransformer) : transportServiceDescriptor.defaultResponseTransformer != null) {
            return false;
        }
        if (this.dispatcherFactory != null ? !this.dispatcherFactory.equals(transportServiceDescriptor.dispatcherFactory) : transportServiceDescriptor.dispatcherFactory != null) {
            return false;
        }
        if (this.endpointBuilder != null ? !this.endpointBuilder.equals(transportServiceDescriptor.endpointBuilder) : transportServiceDescriptor.endpointBuilder != null) {
            return false;
        }
        if (this.messageAdapter != null ? !this.messageAdapter.equals(transportServiceDescriptor.messageAdapter) : transportServiceDescriptor.messageAdapter != null) {
            return false;
        }
        if (this.messageReceiver != null ? !this.messageReceiver.equals(transportServiceDescriptor.messageReceiver) : transportServiceDescriptor.messageReceiver != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(transportServiceDescriptor.properties) : transportServiceDescriptor.properties != null) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals(transportServiceDescriptor.protocol) : transportServiceDescriptor.protocol != null) {
            return false;
        }
        if (this.serviceError != null ? !this.serviceError.equals(transportServiceDescriptor.serviceError) : transportServiceDescriptor.serviceError != null) {
            return false;
        }
        if (this.serviceFinder != null ? !this.serviceFinder.equals(transportServiceDescriptor.serviceFinder) : transportServiceDescriptor.serviceFinder != null) {
            return false;
        }
        if (this.serviceLocation != null ? !this.serviceLocation.equals(transportServiceDescriptor.serviceLocation) : transportServiceDescriptor.serviceLocation != null) {
            return false;
        }
        if (this.sessionHandler != null ? !this.sessionHandler.equals(transportServiceDescriptor.sessionHandler) : transportServiceDescriptor.sessionHandler != null) {
            return false;
        }
        if (this.streamMessageAdapter != null ? !this.streamMessageAdapter.equals(transportServiceDescriptor.streamMessageAdapter) : transportServiceDescriptor.streamMessageAdapter != null) {
            return false;
        }
        if (this.transactedMessageReceiver != null ? !this.transactedMessageReceiver.equals(transportServiceDescriptor.transactedMessageReceiver) : transportServiceDescriptor.transactedMessageReceiver != null) {
            return false;
        }
        return !(this.transactionFactory != null ? !this.transactionFactory.equals(transportServiceDescriptor.transactionFactory) : transportServiceDescriptor.transactionFactory != null);
    }

    public int hashCode() {
        int result = this.protocol != null ? this.protocol.hashCode() : 0;
        result = 29 * result + (this.serviceLocation != null ? this.serviceLocation.hashCode() : 0);
        result = 29 * result + (this.serviceError != null ? this.serviceError.hashCode() : 0);
        result = 29 * result + (this.serviceFinder != null ? this.serviceFinder.hashCode() : 0);
        result = 29 * result + (this.connector != null ? this.connector.hashCode() : 0);
        result = 29 * result + (this.connectorFactory != null ? this.connectorFactory.hashCode() : 0);
        result = 29 * result + (this.dispatcherFactory != null ? this.dispatcherFactory.hashCode() : 0);
        result = 29 * result + (this.transactionFactory != null ? this.transactionFactory.hashCode() : 0);
        result = 29 * result + (this.messageAdapter != null ? this.messageAdapter.hashCode() : 0);
        result = 29 * result + (this.streamMessageAdapter != null ? this.streamMessageAdapter.hashCode() : 0);
        result = 29 * result + (this.messageReceiver != null ? this.messageReceiver.hashCode() : 0);
        result = 29 * result + (this.transactedMessageReceiver != null ? this.transactedMessageReceiver.hashCode() : 0);
        result = 29 * result + (this.endpointBuilder != null ? this.endpointBuilder.hashCode() : 0);
        result = 29 * result + (this.sessionHandler != null ? this.sessionHandler.hashCode() : 0);
        result = 29 * result + (this.defaultInboundTransformer != null ? this.defaultInboundTransformer.hashCode() : 0);
        result = 29 * result + (this.defaultOutboundTransformer != null ? this.defaultOutboundTransformer.hashCode() : 0);
        result = 29 * result + (this.defaultResponseTransformer != null ? this.defaultResponseTransformer.hashCode() : 0);
        return 29 * result + (this.properties != null ? this.properties.hashCode() : 0);
    }
}

