/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import org.mule.impl.AbstractExceptionListener;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.impl.message.ExceptionPayload;
import org.mule.providers.NullPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.util.ObjectUtils;

public class DefaultExceptionStrategy
extends AbstractExceptionListener {
    public void handleMessagingException(UMOMessage message, Throwable t) {
        this.defaultHandler(t);
        this.routeException(message, null, t);
    }

    public void handleRoutingException(UMOMessage message, UMOImmutableEndpoint endpoint, Throwable t) {
        this.defaultHandler(t);
        this.routeException(message, endpoint, t);
    }

    public void handleLifecycleException(Object component, Throwable t) {
        this.handleStandardException(t);
        this.logger.error((Object)("The object that failed was: \n" + ObjectUtils.toString((Object)component, (String)"null")));
    }

    public void handleStandardException(Throwable t) {
        this.markTransactionForRollback();
        if (RequestContext.getEventContext() != null) {
            this.handleMessagingException(RequestContext.getEventContext().getMessage(), t);
        } else {
            this.logger.info((Object)"There is no current event available, routing Null message with the exception");
            this.handleMessagingException(new MuleMessage(NullPayload.getInstance()), t);
        }
    }

    protected void defaultHandler(Throwable t) {
        if (RequestContext.getEvent() != null) {
            RequestContext.setExceptionPayload(new ExceptionPayload(t));
        }
    }
}

