/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.security;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.SecurityException;
import org.mule.umo.security.SecurityProviderNotFoundException;
import org.mule.umo.security.UMOAuthentication;
import org.mule.umo.security.UMOSecurityContext;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.umo.security.UMOSecurityProvider;
import org.mule.umo.security.UnknownAuthenticationTypeException;

public class MuleSecurityManager
implements UMOSecurityManager {
    protected static final Log logger = LogFactory.getLog((Class)MuleSecurityManager.class);
    private Map providers = new ConcurrentHashMap();
    private Map cryptoStrategies = new ConcurrentHashMap();

    public void initialise() throws InitialisationException {
        Iterator iterator = this.providers.values().iterator();
        while (iterator.hasNext()) {
            UMOSecurityProvider provider = (UMOSecurityProvider)iterator.next();
            provider.initialise();
        }
        iterator = this.cryptoStrategies.values().iterator();
        while (iterator.hasNext()) {
            UMOEncryptionStrategy strategy = (UMOEncryptionStrategy)iterator.next();
            strategy.initialise();
        }
    }

    public UMOAuthentication authenticate(UMOAuthentication authentication) throws SecurityException, SecurityProviderNotFoundException {
        Iterator iter = this.providers.values().iterator();
        Class<?> toTest = authentication.getClass();
        while (iter.hasNext()) {
            UMOAuthentication result;
            UMOSecurityProvider provider = (UMOSecurityProvider)iter.next();
            if (!provider.supports(toTest)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication attempt using " + provider.getClass().getName()));
            }
            if ((result = provider.authenticate(authentication)) == null) continue;
            return result;
        }
        throw new SecurityProviderNotFoundException(toTest.getName());
    }

    public void addProvider(UMOSecurityProvider provider) {
        if (this.getProvider(provider.getName()) != null) {
            throw new IllegalArgumentException("Provider already registered: " + provider.getName());
        }
        this.providers.put(provider.getName(), provider);
    }

    public UMOSecurityProvider getProvider(String name) {
        if (name == null) {
            throw new IllegalArgumentException("provider Name cannot be null");
        }
        return (UMOSecurityProvider)this.providers.get(name);
    }

    public UMOSecurityProvider removeProvider(String name) {
        return (UMOSecurityProvider)this.providers.remove(name);
    }

    public List getProviders() {
        return Collections.unmodifiableList(new ArrayList(this.providers.values()));
    }

    public void setProviders(List providers) {
        Iterator iterator = providers.iterator();
        while (iterator.hasNext()) {
            UMOSecurityProvider provider = (UMOSecurityProvider)iterator.next();
            this.addProvider(provider);
        }
    }

    public UMOSecurityContext createSecurityContext(UMOAuthentication authentication) throws UnknownAuthenticationTypeException {
        Iterator iter = this.providers.values().iterator();
        Class<?> toTest = authentication.getClass();
        while (iter.hasNext()) {
            UMOSecurityProvider provider = (UMOSecurityProvider)iter.next();
            if (!provider.supports(toTest)) continue;
            return provider.createSecurityContext(authentication);
        }
        throw new UnknownAuthenticationTypeException(authentication);
    }

    public UMOEncryptionStrategy getEncryptionStrategy(String name) {
        return (UMOEncryptionStrategy)this.cryptoStrategies.get(name);
    }

    public void addEncryptionStrategy(String name, UMOEncryptionStrategy strategy) {
        this.cryptoStrategies.put(name, strategy);
    }

    public UMOEncryptionStrategy removeEncryptionStrategy(String name) {
        return (UMOEncryptionStrategy)this.cryptoStrategies.remove(name);
    }

    public void setEncryptionStrategies(Map strategies) {
        this.cryptoStrategies.putAll(strategies);
    }
}

