/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.xa;

import org.mule.util.xa.ResourceManagerException;
import org.safehaus.uuid.UUIDGenerator;

public class AbstractTransactionContext {
    private static UUIDGenerator gen = UUIDGenerator.getInstance();
    protected String id = gen.generateTimeBasedUUID().toString();
    protected long timeout;
    protected int status = 6;
    protected boolean readOnly = true;
    protected boolean suspended = false;
    protected boolean finished = false;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.id).append("[");
        sb.append(this.getStatusString());
        if (this.suspended) {
            sb.append(", suspended");
        }
        if (this.readOnly) {
            sb.append(", readonly");
        }
        if (this.finished) {
            sb.append(", finished");
        }
        sb.append("]");
        return sb.toString();
    }

    private String getStatusString() {
        switch (this.status) {
            case 0: {
                return "active";
            }
            case 1: {
                return "marked rollback";
            }
            case 2: {
                return "prepared";
            }
            case 3: {
                return "committed";
            }
            case 4: {
                return "rolled back";
            }
            case 5: {
                return "unknown";
            }
            case 6: {
                return "no transaction";
            }
            case 7: {
                return "preparing";
            }
            case 8: {
                return "committing";
            }
            case 9: {
                return "rolling back";
            }
        }
        return "undefined status";
    }

    public synchronized void finalCleanUp() throws ResourceManagerException {
    }

    public synchronized void notifyFinish() {
        this.finished = true;
        this.notifyAll();
    }
}

