/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.util.LinkedList;
import org.mule.util.queue.QueueConfiguration;

public class QueueInfo {
    protected LinkedList list;
    protected String name;
    protected QueueConfiguration config;

    public boolean equals(Object obj) {
        return obj instanceof QueueInfo && this.name.equals(((QueueInfo)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNow(Object o) {
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            this.list.addLast(o);
            this.list.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object o, int room, long timeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            if (this.config.capacity > 0) {
                if (this.config.capacity <= room) {
                    throw new IllegalStateException("Can not add more objects than the capacity in one time");
                }
                long l1 = timeout > 0L ? System.currentTimeMillis() : 0L;
                long l2 = timeout;
                while (this.list.size() >= this.config.capacity - room) {
                    if (l2 <= 0L) {
                        return false;
                    }
                    this.list.wait(l2);
                    l2 = timeout - (System.currentTimeMillis() - l1);
                }
            }
            if (o != null) {
                this.list.addLast(o);
            }
            this.list.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long timeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            long l1 = timeout > 0L ? System.currentTimeMillis() : 0L;
            long l2 = timeout;
            while (this.list.isEmpty()) {
                if (l2 <= 0L) {
                    return null;
                }
                this.list.wait(l2);
                l2 = timeout - (System.currentTimeMillis() - l1);
            }
            Object o = this.list.removeFirst();
            this.list.notifyAll();
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            if (this.list.isEmpty()) {
                return null;
            }
            return this.list.getFirst();
        }
    }
}

