/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOTransaction;

public final class TransactionCoordination {
    protected static final Log logger = LogFactory.getLog((Class)TransactionCoordination.class);
    private static final TransactionCoordination instance = new TransactionCoordination();
    private static final ThreadLocal transactions = new ThreadLocal();
    private int txCounter = 0;

    private TransactionCoordination() {
    }

    public static TransactionCoordination getInstance() {
        return instance;
    }

    public UMOTransaction getTransaction() {
        return (UMOTransaction)transactions.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindTransaction(UMOTransaction transaction) throws TransactionException {
        TransactionCoordination transactionCoordination;
        try {
            UMOTransaction oldTx = (UMOTransaction)transactions.get();
            if (oldTx != null && !oldTx.equals(transaction)) {
                throw new IllegalTransactionStateException(CoreMessages.transactionCannotUnbind());
            }
            Object var4_3 = null;
            transactions.set(null);
            transactionCoordination = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            transactions.set(null);
            TransactionCoordination transactionCoordination2 = this;
            synchronized (transactionCoordination2) {
                if (this.txCounter > 0) {
                    --this.txCounter;
                }
            }
            throw throwable;
        }
        synchronized (transactionCoordination) {
            if (this.txCounter > 0) {
                --this.txCounter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindTransaction(UMOTransaction transaction) throws TransactionException {
        UMOTransaction oldTx = (UMOTransaction)transactions.get();
        if (oldTx != null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionAlreadyBound());
        }
        transactions.set(transaction);
        TransactionCoordination transactionCoordination = this;
        synchronized (transactionCoordination) {
            ++this.txCounter;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Binding new transaction (" + this.txCounter + ")"));
            }
        }
    }
}

