/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.internal.notifications.TransactionNotification;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOTransaction;

public abstract class AbstractTransaction
implements UMOTransaction {
    protected final transient Log logger = LogFactory.getLog(this.getClass());

    public boolean isRollbackOnly() throws TransactionException {
        return this.getStatus() == 1;
    }

    public boolean isBegun() throws TransactionException {
        int status = this.getStatus();
        return status != 6 && status != 5;
    }

    public boolean isRolledBack() throws TransactionException {
        return this.getStatus() == 4;
    }

    public boolean isCommitted() throws TransactionException {
        return this.getStatus() == 3;
    }

    public void begin() throws TransactionException {
        this.logger.debug((Object)"Beginning transaction");
        this.doBegin();
        TransactionCoordination.getInstance().bindTransaction(this);
        this.fireNotification(new TransactionNotification(this, 1201));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws TransactionException {
        try {
            this.logger.debug((Object)"Committing transaction");
            if (this.isRollbackOnly()) {
                throw new IllegalTransactionStateException(CoreMessages.transactionMarkedForRollback());
            }
            this.doCommit();
            this.fireNotification(new TransactionNotification(this, 1202));
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws TransactionException {
        try {
            this.logger.debug((Object)"Rolling back transaction");
            this.setRollbackOnly();
            this.doRollback();
            this.fireNotification(new TransactionNotification(this, 1203));
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(this);
        }
    }

    protected abstract void doBegin() throws TransactionException;

    protected abstract void doCommit() throws TransactionException;

    protected abstract void doRollback() throws TransactionException;

    protected void fireNotification(TransactionNotification notification) {
        MuleManager.getInstance().fireNotification(notification);
    }
}

