/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.AbstractTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionStatusException;
import org.mule.umo.TransactionException;

public abstract class AbstractSingleResourceTransaction
extends AbstractTransaction {
    protected volatile Object key;
    protected volatile Object resource;
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final AtomicBoolean committed = new AtomicBoolean(false);
    protected final AtomicBoolean rolledBack = new AtomicBoolean(false);
    protected final AtomicBoolean rollbackOnly = new AtomicBoolean(false);

    public void begin() throws TransactionException {
        super.begin();
        this.started.compareAndSet(false, true);
    }

    public void commit() throws TransactionException {
        super.commit();
        this.committed.compareAndSet(false, true);
    }

    public void rollback() throws TransactionException {
        super.rollback();
        this.rolledBack.compareAndSet(false, true);
    }

    public int getStatus() throws TransactionStatusException {
        if (this.rolledBack.get()) {
            return 4;
        }
        if (this.committed.get()) {
            return 3;
        }
        if (this.rollbackOnly.get()) {
            return 1;
        }
        if (this.started.get()) {
            return 0;
        }
        return 6;
    }

    public Object getResource(Object key) {
        return key != null && this.key == key ? this.resource : null;
    }

    public boolean hasResource(Object key) {
        return key != null && this.key == key;
    }

    public void bindResource(Object key, Object resource) throws TransactionException {
        if (key == null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCannotBindToNullKey());
        }
        if (resource == null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCannotBindNullResource());
        }
        if (this.key != null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionSingleResourceOnly());
        }
        this.key = key;
        this.resource = resource;
    }

    public void setRollbackOnly() {
        this.rollbackOnly.set(true);
    }

    public Object getId() {
        return this.key;
    }
}

