/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mule.routing.inbound.IdempotentReceiver;
import org.mule.transformers.simple.ByteArrayToHexString;
import org.mule.transformers.simple.SerializableToByteArray;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.transformer.TransformerException;

public class IdempotentSecureHashReceiver
extends IdempotentReceiver {
    private static final String messageDigestAlgorithm = "SHA-256";
    private final SerializableToByteArray objectToByteArray = new SerializableToByteArray();
    private final ByteArrayToHexString byteArrayToHexString = new ByteArrayToHexString();

    protected Object getIdForEvent(UMOEvent event) throws MessagingException {
        try {
            MessageDigest md = MessageDigest.getInstance(messageDigestAlgorithm);
            return this.byteArrayToHexString.transform(md.digest((byte[])this.objectToByteArray.transform(event.getMessage().getPayload())));
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)nsa);
        }
        catch (TransformerException te) {
            throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)te);
        }
    }
}

