/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.mule.config.pool.CommonsPoolFactory;
import org.mule.umo.model.UMOPoolFactory;
import org.mule.util.MapUtils;

public class PoolingProfile {
    public static final int INITIALISE_NONE = 0;
    public static final int POOL_INITIALISE_NO_COMPONENTS = 0;
    public static final int INITIALISE_ONE = 1;
    public static final int POOL_INITIALISE_ONE_COMPONENT = 1;
    public static final int INITIALISE_ALL = 2;
    public static final int POOL_INITIALISE_ALL_COMPONENTS = 2;
    public static final int DEFAULT_MAX_POOL_ACTIVE = 5;
    public static final int DEFAULT_MAX_POOL_IDLE = 5;
    public static final long DEFAULT_MAX_POOL_WAIT = 4000L;
    public static final int DEFAULT_POOL_EXHAUSTED_ACTION = 2;
    public static final int DEFAULT_POOL_INITIALISATION_POLICY = 1;
    private static final Map POOL_EXHAUSTED_ACTIONS = new CaseInsensitiveMap(){
        private static final long serialVersionUID = 1L;
        {
            Integer value = new Integer(1);
            this.put("WHEN_EXHAUSTED_WAIT", value);
            this.put("WAIT", value);
            this.put("BLOCK", value);
            value = new Integer(0);
            this.put("WHEN_EXHAUSTED_FAIL", value);
            this.put("FAIL", value);
            value = new Integer(2);
            this.put("WHEN_EXHAUSTED_GROW", value);
            this.put("GROW", value);
        }
    };
    private static final Map POOL_INITIALISATION_POLICIES = new CaseInsensitiveMap(){
        private static final long serialVersionUID = 1L;
        {
            Integer value = new Integer(0);
            this.put("INITIALISE_NONE", value);
            value = new Integer(1);
            this.put("INITIALISE_ONE", value);
            this.put("INITIALISE_FIRST", value);
            value = new Integer(2);
            this.put("INITIALISE_ALL", value);
        }
    };
    private int maxActive = 5;
    private int maxIdle = 5;
    private long maxWait = 4000L;
    private int exhaustedAction = 2;
    private int initialisationPolicy = 1;
    private UMOPoolFactory poolFactory = new CommonsPoolFactory();

    public PoolingProfile() {
    }

    public PoolingProfile(PoolingProfile pp) {
        this.maxActive = pp.getMaxActive();
        this.maxIdle = pp.getMaxIdle();
        this.maxWait = pp.getMaxWait();
        this.exhaustedAction = pp.getExhaustedAction();
        this.initialisationPolicy = pp.getInitialisationPolicy();
        if (pp.getPoolFactory() != null) {
            this.poolFactory = pp.getPoolFactory();
        }
    }

    public PoolingProfile(int maxActive, int maxIdle, long maxWait, int exhaustedAction, int initialisationPolicy) {
        this.maxActive = maxActive;
        this.maxIdle = maxIdle;
        this.maxWait = maxWait;
        this.exhaustedAction = exhaustedAction;
        this.initialisationPolicy = initialisationPolicy;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public int getExhaustedAction() {
        return this.exhaustedAction;
    }

    public int getInitialisationPolicy() {
        return this.initialisationPolicy;
    }

    public void setInitialisationPolicy(int policy) {
        this.initialisationPolicy = policy;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public void setExhaustedAction(int exhaustedAction) {
        this.exhaustedAction = exhaustedAction;
    }

    public void setExhaustedActionString(String poolExhaustedAction) {
        this.exhaustedAction = MapUtils.getIntValue((Map)POOL_EXHAUSTED_ACTIONS, (Object)poolExhaustedAction, (int)1);
    }

    public void setInitialisationPolicyString(String policy) {
        this.initialisationPolicy = MapUtils.getIntValue((Map)POOL_INITIALISATION_POLICIES, (Object)policy, (int)1);
    }

    public UMOPoolFactory getPoolFactory() {
        return this.poolFactory;
    }

    public void setPoolFactory(UMOPoolFactory poolFactory) {
        this.poolFactory = poolFactory;
    }
}

