/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.mule.util.queue.QueuePersistenceStrategy;

public class CachingPersistenceStrategy
implements QueuePersistenceStrategy {
    private QueuePersistenceStrategy ps;
    private Map objects;

    public CachingPersistenceStrategy(QueuePersistenceStrategy ps) {
        this.ps = ps;
        this.objects = Collections.synchronizedMap(new ReferenceMap());
    }

    public void open() throws IOException {
        this.ps.open();
    }

    public void close() throws IOException {
        this.objects.clear();
        this.ps.close();
    }

    public Object load(String queue, Object id) throws IOException {
        return this.ps.load(queue, id);
    }

    public void remove(String queue, Object id) throws IOException {
        this.objects.remove(id);
        this.ps.remove(queue, id);
    }

    public List restore() throws IOException {
        return this.ps.restore();
    }

    public Object store(String queue, Object obj) throws IOException {
        Object id = this.ps.store(queue, obj);
        this.objects.put(id, obj);
        return id;
    }

    public boolean isTransient() {
        return this.ps.isTransient();
    }
}

