/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.beans.ExceptionListener;
import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.RequestContext;
import org.mule.impl.internal.notifications.ConnectionNotification;
import org.mule.impl.internal.notifications.MessageNotification;
import org.mule.impl.internal.notifications.SecurityNotification;
import org.mule.providers.AbstractConnectionStrategy;
import org.mule.providers.AbstractConnector;
import org.mule.providers.ConnectException;
import org.mule.providers.ConnectionStrategy;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.ReceiveException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.security.SecurityException;
import org.mule.util.ClassUtils;

public abstract class AbstractMessageDispatcher
implements UMOMessageDispatcher,
ExceptionListener {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected UMOWorkManager workManager = null;
    protected final UMOImmutableEndpoint endpoint;
    protected final AbstractConnector connector;
    protected boolean disposed = false;
    protected ConnectionStrategy connectionStrategy;
    protected volatile boolean connecting = false;
    protected volatile boolean connected = false;

    public AbstractMessageDispatcher(UMOImmutableEndpoint endpoint) {
        AbstractConnectionStrategy connStrategy;
        this.endpoint = endpoint;
        this.connector = (AbstractConnector)endpoint.getConnector();
        this.connectionStrategy = this.connector.getConnectionStrategy();
        if (this.connectionStrategy instanceof AbstractConnectionStrategy && (connStrategy = (AbstractConnectionStrategy)this.connectionStrategy).isDoThreading()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Overriding doThreading to false on " + connStrategy));
            }
            connStrategy.setDoThreading(false);
        }
        if (this.isDoThreading()) {
            try {
                this.workManager = this.connector.getDispatcherWorkManager();
            }
            catch (UMOException e) {
                this.dispose();
                throw new MuleRuntimeException(CoreMessages.failedToStart("WorkManager"), (Throwable)e);
            }
        }
    }

    public final void dispatch(UMOEvent event) throws DispatchException {
        event.setSynchronous(false);
        event.getMessage().setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().toString());
        RequestContext.setEvent(event);
        UMOImmutableEndpoint endpoint = event.getEndpoint();
        if (endpoint.getSecurityFilter() != null) {
            try {
                endpoint.getSecurityFilter().authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                this.connector.fireNotification(new SecurityNotification(e, 600));
                this.connector.handleException(e);
                return;
            }
            catch (UMOException e) {
                this.dispose();
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        event = RequestContext.getEvent();
        try {
            UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
            if (this.isDoThreading() && !event.isSynchronous() && tx == null) {
                this.workManager.scheduleWork(new Worker(event), Long.MAX_VALUE, null, this.connector);
            } else {
                this.connectionStrategy.connect(this);
                this.doDispatch(event);
                if (this.connector.isEnableMessageEvents()) {
                    String component = null;
                    if (event.getComponent() != null) {
                        component = event.getComponent().getDescriptor().getName();
                    }
                    this.connector.fireNotification(new MessageNotification(event.getMessage(), event.getEndpoint(), component, 802));
                }
            }
        }
        catch (DispatchException e) {
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            this.dispose();
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    public final UMOMessage send(UMOEvent event) throws DispatchException {
        if (this.isTransactionRollback()) {
            return event.getMessage();
        }
        event.setSynchronous(true);
        event.getMessage().setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().toString());
        RequestContext.setEvent(event);
        UMOImmutableEndpoint endpoint = event.getEndpoint();
        if (endpoint.getSecurityFilter() != null) {
            try {
                endpoint.getSecurityFilter().authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                this.connector.fireNotification(new SecurityNotification(e, 401));
                this.connector.handleException(e);
                return event.getMessage();
            }
            catch (UMOException e) {
                this.dispose();
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        event = RequestContext.getEvent();
        try {
            this.connectionStrategy.connect(this);
            UMOMessage result = this.doSend(event);
            if (this.connector.isEnableMessageEvents()) {
                String component = null;
                if (event.getComponent() != null) {
                    component = event.getComponent().getDescriptor().getName();
                }
                this.connector.fireNotification(new MessageNotification(event.getMessage(), event.getEndpoint(), component, 803));
            }
            if (result != null) {
                result.removeProperty("MULE_REMOTE_SYNC");
            }
            return result;
        }
        catch (DispatchException e) {
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            this.dispose();
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    public final UMOMessage receive(long timeout) throws Exception {
        try {
            this.connectionStrategy.connect(this);
            UMOMessage result = this.doReceive(timeout);
            if (result != null && this.connector.isEnableMessageEvents()) {
                this.connector.fireNotification(new MessageNotification(result, this.endpoint, null, 801));
            }
            return result;
        }
        catch (DispatchException e) {
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            this.dispose();
            throw new ReceiveException(this.endpoint, timeout, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionThrown(Exception e) {
        try {
            this.getConnector().handleException(e);
        }
        finally {
            this.dispose();
        }
    }

    public boolean validate() {
        return !this.disposed;
    }

    public void activate() {
    }

    public void passivate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void dispose() {
        if (!this.disposed) {
            try {
                try {
                    this.disconnect();
                }
                catch (Exception e) {
                    this.logger.warn((Object)e.getMessage(), (Throwable)e);
                }
                this.doDispose();
                if (this.workManager != null) {
                    this.workManager.dispose();
                }
            }
            finally {
                this.disposed = true;
            }
        }
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public UMOImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    protected boolean useRemoteSync(UMOEvent event) {
        boolean remoteSync = false;
        if (event.getEndpoint().getConnector().isRemoteSyncEnabled()) {
            boolean bl = remoteSync = event.getEndpoint().isRemoteSync() || event.getMessage().getBooleanProperty("MULE_REMOTE_SYNC", false);
            if (remoteSync && event.getComponent() != null) {
                boolean bl2 = remoteSync = event.getComponent().getDescriptor().getResponseRouter() == null;
            }
        }
        if (!remoteSync) {
            event.getMessage().removeProperty("MULE_REMOTE_SYNC");
        }
        return remoteSync;
    }

    public synchronized void connect() throws Exception {
        if (this.disposed) {
            throw new IllegalStateException("Dispatcher has been disposed; cannot connect to resource");
        }
        if (this.connected) {
            return;
        }
        if (!this.connecting) {
            this.connecting = true;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Connecting: " + this));
            }
            this.connectionStrategy.connect(this);
            this.logger.info((Object)("Connected: " + this));
            return;
        }
        try {
            this.doConnect();
            this.connected = true;
            this.connecting = false;
            this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(this.endpoint), 701));
        }
        catch (Exception e) {
            this.connected = false;
            this.connecting = false;
            this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(this.endpoint), 702));
            if (e instanceof ConnectException) {
                throw (ConnectException)e;
            }
            throw new ConnectException(e, (Object)this);
        }
    }

    public synchronized void disconnect() throws Exception {
        if (!this.connected) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnecting: " + this));
        }
        this.doDisconnect();
        this.connected = false;
        this.logger.info((Object)("Disconnected: " + this));
        this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(this.endpoint), 703));
    }

    protected String getConnectEventId(UMOImmutableEndpoint endpoint) {
        return this.connector.getName() + ".dispatcher(" + endpoint.getEndpointURI() + ")";
    }

    public final boolean isConnected() {
        return this.connected;
    }

    protected boolean isDoThreading() {
        return this.connector.getDispatcherThreadingProfile().isDoThreading();
    }

    public String getConnectionDescription() {
        return this.endpoint.getEndpointURI().toString();
    }

    public synchronized void reconnect() throws Exception {
        this.disconnect();
        this.connect();
    }

    protected abstract void doDispose();

    protected abstract void doDispatch(UMOEvent var1) throws Exception;

    protected abstract UMOMessage doSend(UMOEvent var1) throws Exception;

    protected abstract void doConnect() throws Exception;

    protected abstract void doDisconnect() throws Exception;

    protected abstract UMOMessage doReceive(long var1) throws Exception;

    protected boolean isTransactionRollback() {
        try {
            UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
            if (tx != null && tx.isRollbackOnly()) {
                return true;
            }
        }
        catch (TransactionException e) {
            this.logger.warn((Object)e.getMessage());
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", endpoint=").append(this.endpoint.getEndpointURI());
        sb.append('}');
        return sb.toString();
    }

    private class Worker
    implements Work {
        private final UMOEvent event;

        public Worker(UMOEvent event) {
            this.event = event;
        }

        public void run() {
            try {
                RequestContext.setEvent(this.event);
                AbstractMessageDispatcher.this.connectionStrategy.connect(AbstractMessageDispatcher.this);
                AbstractMessageDispatcher.this.doDispatch(this.event);
                if (AbstractMessageDispatcher.this.connector.isEnableMessageEvents()) {
                    String component = null;
                    if (this.event.getComponent() != null) {
                        component = this.event.getComponent().getDescriptor().getName();
                    }
                    AbstractMessageDispatcher.this.connector.fireNotification(new MessageNotification(this.event.getMessage(), this.event.getEndpoint(), component, 802));
                }
            }
            catch (Exception e) {
                AbstractMessageDispatcher.this.getConnector().handleException(e);
            }
        }

        public void release() {
        }
    }
}

