/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.umo.UMOExceptionPayload;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.MapUtils;
import org.mule.util.UUID;

public abstract class AbstractMessageAdapter
implements UMOMessageAdapter {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ConcurrentMap properties = new ConcurrentHashMap();
    protected ConcurrentMap attachments = new ConcurrentHashMap();
    protected String encoding = MuleManager.getConfiguration().getEncoding();
    protected UMOExceptionPayload exceptionPayload;
    protected String id = UUID.getUUID();

    public String toString() {
        StringBuffer buf = new StringBuffer(120);
        buf.append(this.getClass().getName());
        buf.append('{');
        buf.append("id=").append(this.getUniqueId());
        buf.append(", payload=").append(this.getPayload().getClass().getName());
        buf.append(", correlationId=").append(this.getCorrelationId());
        buf.append(", correlationGroup=").append(this.getCorrelationGroupSize());
        buf.append(", correlationSeq=").append(this.getCorrelationSequence());
        buf.append(", encoding=").append(this.getEncoding());
        buf.append(", exceptionPayload=").append(this.exceptionPayload);
        buf.append(", properties=").append(MapUtils.toString((Map)this.properties, true));
        buf.append('}');
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(Map props) {
        if (props != null) {
            Map map = props;
            synchronized (map) {
                Iterator iter = props.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    this.setProperty((String)entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Object removeProperty(String key) {
        return this.properties.remove((Object)key);
    }

    public Object getProperty(String key) {
        return this.properties.get((Object)key);
    }

    public Set getPropertyNames() {
        return this.properties.keySet();
    }

    public void setProperty(String key, Object value) {
        if (key != null) {
            if (value != null) {
                this.properties.put((Object)key, value);
            } else {
                this.logger.warn((Object)("setProperty(key, value) called with null value; removing key: " + key + "; please report the following stack trace to dev@mule.codehaus.org."), new Throwable());
                this.properties.remove((Object)key);
            }
        } else {
            this.logger.warn((Object)("setProperty(key, value) ignored because of null key for object: " + value + "; please report the following stack trace to dev@mule.codehaus.org."), new Throwable());
        }
    }

    public String getUniqueId() {
        return this.id;
    }

    public Object getProperty(String name, Object defaultValue) {
        return MapUtils.getObject((Map)this.properties, (Object)name, (Object)defaultValue);
    }

    public int getIntProperty(String name, int defaultValue) {
        return MapUtils.getIntValue((Map)this.properties, (Object)name, (int)defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        return MapUtils.getLongValue((Map)this.properties, (Object)name, (long)defaultValue);
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return MapUtils.getDoubleValue((Map)this.properties, (Object)name, (double)defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return MapUtils.getBooleanValue((Map)this.properties, (Object)name, (boolean)defaultValue);
    }

    public String getStringProperty(String name, String defaultValue) {
        return MapUtils.getString((Map)this.properties, (Object)name, (String)defaultValue);
    }

    public void setBooleanProperty(String name, boolean value) {
        this.setProperty(name, value);
    }

    public void setIntProperty(String name, int value) {
        this.setProperty(name, new Integer(value));
    }

    public void setLongProperty(String name, long value) {
        this.setProperty(name, new Long(value));
    }

    public void setDoubleProperty(String name, double value) {
        this.setProperty(name, new Double(value));
    }

    public void setStringProperty(String name, String value) {
        this.setProperty(name, value);
    }

    public Object getReplyTo() {
        return this.getProperty("MULE_REPLYTO");
    }

    public void setReplyTo(Object replyTo) {
        if (replyTo != null) {
            this.setProperty("MULE_REPLYTO", replyTo);
        } else {
            this.removeProperty("MULE_REPLYTO");
        }
    }

    public String getCorrelationId() {
        return (String)this.getProperty("MULE_CORRELATION_ID");
    }

    public void setCorrelationId(String correlationId) {
        if (StringUtils.isNotBlank((String)correlationId)) {
            this.setProperty("MULE_CORRELATION_ID", correlationId);
        } else {
            this.removeProperty("MULE_CORRELATION_ID");
        }
    }

    public int getCorrelationSequence() {
        return this.getIntProperty("MULE_CORRELATION_SEQUENCE", -1);
    }

    public void setCorrelationSequence(int sequence) {
        this.setIntProperty("MULE_CORRELATION_SEQUENCE", sequence);
    }

    public int getCorrelationGroupSize() {
        return this.getIntProperty("MULE_CORRELATION_GROUP_SIZE", -1);
    }

    public void setCorrelationGroupSize(int size) {
        this.setIntProperty("MULE_CORRELATION_GROUP_SIZE", size);
    }

    public UMOExceptionPayload getExceptionPayload() {
        return this.exceptionPayload;
    }

    public void setExceptionPayload(UMOExceptionPayload payload) {
        this.exceptionPayload = payload;
    }

    public void addAttachment(String name, DataHandler dataHandler) throws Exception {
        this.attachments.put((Object)name, (Object)dataHandler);
    }

    public void removeAttachment(String name) throws Exception {
        this.attachments.remove((Object)name);
    }

    public DataHandler getAttachment(String name) {
        return (DataHandler)this.attachments.get((Object)name);
    }

    public Set getAttachmentNames() {
        return this.attachments.keySet();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final String getPayloadAsString() throws Exception {
        return this.getPayloadAsString(this.getEncoding());
    }

    protected byte[] convertToBytes(Object object) throws TransformerException, UnsupportedEncodingException {
        if (object instanceof String) {
            return object.toString().getBytes(this.getEncoding());
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof Serializable) {
            try {
                return SerializationUtils.serialize((Serializable)((Serializable)object));
            }
            catch (Exception e) {
                throw new TransformerException(CoreMessages.transformFailed(object.getClass().getName(), "byte[]"), (Throwable)e);
            }
        }
        throw new TransformerException(CoreMessages.transformOnObjectNotOfSpecifiedType(object.getClass().getName(), "byte[] or " + Serializable.class.getName()));
    }
}

