/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.container;

import java.io.Reader;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.container.ContainerKeyPair;
import org.mule.impl.container.DescriptorContainerContext;
import org.mule.impl.container.MuleContainerContext;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.umo.manager.UMOContainerContext;

public class MultiContainerContext
implements UMOContainerContext {
    protected static final Log logger = LogFactory.getLog((Class)MultiContainerContext.class);
    private String name = "multi";
    private TreeMap containers = new TreeMap();

    public MultiContainerContext() {
        this.addContainer(new MuleContainerContext());
        this.addContainer(new DescriptorContainerContext());
    }

    public void setName(String name) {
    }

    public String getName() {
        return this.name;
    }

    public void addContainer(UMOContainerContext container) {
        if (this.containers.containsKey(container.getName())) {
            throw new IllegalArgumentException(CoreMessages.containerAlreadyRegistered(container.getName()).toString());
        }
        this.containers.put(container.getName(), container);
    }

    public UMOContainerContext removeContainer(String name) {
        return (UMOContainerContext)this.containers.remove(name);
    }

    public Object getComponent(Object key) throws ObjectNotFoundException {
        ContainerKeyPair realKey = null;
        StringBuffer cause = new StringBuffer();
        Throwable finalCause = null;
        realKey = key instanceof String ? new ContainerKeyPair(null, key) : (ContainerKeyPair)key;
        Object component = null;
        if (realKey.getContainerName() != null) {
            UMOContainerContext container = (UMOContainerContext)this.containers.get(realKey.getContainerName());
            if (container != null) {
                return container.getComponent(realKey);
            }
            throw new ObjectNotFoundException("Container: " + realKey.getContainerName());
        }
        Iterator iterator = this.containers.values().iterator();
        while (iterator.hasNext()) {
            UMOContainerContext container = (UMOContainerContext)iterator.next();
            try {
                component = container.getComponent(realKey);
            }
            catch (ObjectNotFoundException e) {
                if (e.getCause() != null) {
                    finalCause = e.getCause();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Object: '" + realKey + "' not found in container: " + container.getName()));
                    }
                } else {
                    finalCause = e;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Object: '" + realKey + "' not found in container: " + container.getName()));
                    }
                }
                if (cause.length() > 0) {
                    cause.append("; ");
                }
                cause.append(finalCause.toString());
            }
            if (component == null) continue;
            if (!logger.isDebugEnabled()) break;
            logger.debug((Object)("Object: '" + realKey + "' found in container: " + container.getName()));
            break;
        }
        if (component == null) {
            if (realKey.isRequired()) {
                throw new ObjectNotFoundException(realKey.toString() + " " + cause, finalCause);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Component reference not found: " + realKey.toFullString()));
                return null;
            }
        }
        return component;
    }

    public void configure(Reader configuration, String doctype, String encoding) throws ContainerException {
    }

    public void dispose() {
        Iterator iterator = this.containers.values().iterator();
        while (iterator.hasNext()) {
            UMOContainerContext container = (UMOContainerContext)iterator.next();
            container.dispose();
        }
        this.containers.clear();
        this.containers = null;
    }

    public void initialise() throws InitialisationException {
    }
}

