/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.container;

import java.io.Reader;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.commons.lang.ObjectUtils;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.container.AbstractContainerContext;
import org.mule.impl.container.JndiContextHelper;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.ObjectNotFoundException;

public class JndiContainerContext
extends AbstractContainerContext {
    protected volatile Context context;
    private volatile Map environment;

    public JndiContainerContext() {
        super("jndi");
    }

    protected JndiContainerContext(String name) {
        super(name);
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map environment) {
        this.environment = environment;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(InitialContext context) {
        this.context = context;
    }

    public Object getComponent(Object key) throws ObjectNotFoundException {
        try {
            if (key == null) {
                throw new ObjectNotFoundException("null");
            }
            if (key instanceof Name) {
                return this.context.lookup((Name)key);
            }
            if (key instanceof Class) {
                return this.context.lookup(((Class)key).getName());
            }
            return this.context.lookup(key.toString());
        }
        catch (NamingException e) {
            throw new ObjectNotFoundException(ObjectUtils.toString((Object)key, (String)"null"), (Throwable)e);
        }
    }

    public void configure(Reader configuration) throws ContainerException {
        throw new UnsupportedOperationException("configure(Reader)");
    }

    public void initialise() throws InitialisationException {
        try {
            if (this.context == null) {
                this.context = JndiContextHelper.initialise(this.getEnvironment());
            }
        }
        catch (NamingException e) {
            throw new InitialisationException(CoreMessages.failedToCreate("Jndi context"), e, this);
        }
    }
}

