/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.mule.config.i18n.Message;
import org.mule.util.IOUtils;
import org.mule.util.MapUtils;

public final class PropertiesUtils {
    private static final List maskedProperties = new CopyOnWriteArrayList();

    protected PropertiesUtils() {
    }

    public static void registerMaskedPropertyName(String name) {
        if (!StringUtils.isNotEmpty((String)name)) {
            throw new IllegalArgumentException("Cannot mask empty property name.");
        }
        maskedProperties.add(name);
    }

    public static String maskedPropertyValue(Map.Entry property) {
        if (property == null) {
            return null;
        }
        Object key = property.getKey();
        Object value = property.getValue();
        if (key == null || value == null) {
            return null;
        }
        if (maskedProperties.contains(key)) {
            return "*****";
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Properties loadProperties(String fileName, Class callingClass) throws IOException {
        InputStream is = IOUtils.getResourceAsStream(fileName, callingClass, true, false);
        if (is == null) {
            Message error = new Message(122, fileName);
            throw new IOException(error.toString());
        }
        try {
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
        finally {
            is.close();
        }
    }

    public static String removeXmlNamespacePrefix(String eleName) {
        int i = eleName.indexOf(58);
        return i == -1 ? eleName : eleName.substring(i + 1, eleName.length());
    }

    public static String removeNamespacePrefix(String eleName) {
        int i = eleName.lastIndexOf(46);
        return i == -1 ? eleName : eleName.substring(i + 1, eleName.length());
    }

    public static Map removeNamespaces(Map properties) {
        HashMap props = new HashMap(properties.size());
        Iterator iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            props.put(PropertiesUtils.removeNamespacePrefix((String)entry.getKey()), entry.getValue());
        }
        return props;
    }

    public static void getPropertiesWithPrefix(Map props, String prefix, Map newProps) {
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            if (!key.toString().startsWith(prefix)) continue;
            newProps.put(key, entry.getValue());
        }
    }

    public static Map getPropertiesWithoutPrefix(Map props, String prefix) {
        HashMap newProps = new HashMap();
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            if (key.toString().startsWith(prefix)) continue;
            newProps.put(key, entry.getValue());
        }
        return newProps;
    }

    public static Properties getPropertiesFromQueryString(String query) {
        Properties props = new Properties();
        if (query == null) {
            return props;
        }
        query = new StringBuffer(query.length() + 1).append('&').append(query).toString();
        int x = 0;
        while ((x = PropertiesUtils.addProperty(query, x, props)) != -1) {
        }
        return props;
    }

    private static int addProperty(String query, int start, Properties properties) {
        String pair;
        int i = query.indexOf(38, start);
        int i2 = query.indexOf(38, i + 1);
        if (i > -1 && i2 > -1) {
            pair = query.substring(i + 1, i2);
        } else if (i > -1) {
            pair = query.substring(i + 1);
        } else {
            return -1;
        }
        int eq = pair.indexOf(61);
        if (eq <= 0) {
            String key = pair;
            String value = "";
            properties.setProperty(key, value);
        } else {
            String key = pair.substring(0, eq);
            String value = eq == pair.length() ? "" : pair.substring(eq + 1);
            properties.setProperty(key, value);
        }
        return i2;
    }

    public static String propertiesToString(Map props, boolean newline) {
        return MapUtils.toString(props, newline);
    }

    static {
        PropertiesUtils.registerMaskedPropertyName("password");
    }
}

