/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.simple;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mule.transformers.AbstractEventAwareTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.transformer.TransformerException;

public class MessagePropertiesTransformer
extends AbstractEventAwareTransformer {
    private Set deleteProperties = null;
    private Map addProperties = null;

    public MessagePropertiesTransformer() {
        this.registerSourceType(Object.class);
        this.setReturnClass(Object.class);
    }

    public Object clone() throws CloneNotSupportedException {
        MessagePropertiesTransformer clone = (MessagePropertiesTransformer)super.clone();
        if (this.deleteProperties != null) {
            clone.setDeleteProperties(new HashSet(this.deleteProperties));
        }
        if (this.addProperties != null) {
            clone.setAddProperties(new HashMap(this.addProperties));
        }
        return clone;
    }

    public Object transform(Object src, String encoding, UMOEventContext context) throws TransformerException {
        Iterator<Object> iterator;
        if (this.deleteProperties != null && this.deleteProperties.size() > 0) {
            iterator = this.deleteProperties.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                context.getMessage().removeProperty(o.toString());
            }
        }
        if (this.addProperties != null && this.addProperties.size() > 0) {
            iterator = this.addProperties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (entry.getKey() == null) {
                    this.logger.error((Object)"Setting Null property keys is not supported, this entry is being ignored");
                    continue;
                }
                context.getMessage().setProperty(entry.getKey().toString(), entry.getValue());
            }
        }
        return context.getMessage();
    }

    public Set getDeleteProperties() {
        return this.deleteProperties;
    }

    public void setDeleteProperties(Set deleteProperties) {
        this.deleteProperties = deleteProperties;
    }

    public Map getAddProperties() {
        return this.addProperties;
    }

    public void setAddProperties(Map addProperties) {
        this.addProperties = addProperties;
    }
}

