/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.Iterator;
import org.mule.config.i18n.Message;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutingException;

public class EndpointSelector
extends FilteringOutboundRouter {
    private String selectorProperty = "endpoint";

    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        String endpointName = message.getStringProperty(this.getSelectorProperty(), null);
        if (endpointName == null) {
            throw new IllegalArgumentException("selectorProperty '" + this.getSelectorProperty() + "' must be set on message in order to route it.");
        }
        UMOEndpoint ep = this.lookupEndpoint(endpointName);
        if (ep == null) {
            throw new CouldNotRouteOutboundMessageException(Message.createStaticMessage("No endpoint found with the name " + endpointName), message, ep);
        }
        try {
            if (synchronous) {
                return this.send(session, message, ep);
            }
            this.dispatch(session, message, ep);
            return null;
        }
        catch (UMOException e) {
            throw new CouldNotRouteOutboundMessageException(message, ep, (Throwable)e);
        }
    }

    protected UMOEndpoint lookupEndpoint(String endpointName) {
        Iterator iterator = this.endpoints.iterator();
        while (iterator.hasNext()) {
            UMOEndpoint ep = (UMOEndpoint)iterator.next();
            if (endpointName.equals(ep.getEndpointURI().getEndpointName())) {
                return ep;
            }
            if (endpointName.equals(ep.getName())) {
                return ep;
            }
            if (!endpointName.equals(ep.getEndpointURI().getUri().toString())) continue;
            return ep;
        }
        return null;
    }

    public String getSelectorProperty() {
        return this.selectorProperty;
    }

    public void setSelectorProperty(String selectorProperty) {
        this.selectorProperty = selectorProperty;
    }
}

