/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.streaming;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOStreamingTransformer;
import org.mule.util.ClassUtils;

public abstract class AbstractStreamingTransformer
implements UMOStreamingTransformer {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected String name = this.generateTransformerName();
    protected UMOImmutableEndpoint endpoint = null;
    protected UMOStreamingTransformer nextTransformer;
    private boolean ignoreBadInput = false;

    public String getName() {
        if (this.name == null) {
            this.setName(ClassUtils.getShortClassName(this.getClass()));
        }
        return this.name;
    }

    public void setName(String string) {
        this.logger.debug((Object)("Setting transformer name to: " + this.name));
        this.name = string;
    }

    public final Object transform(InputStream src, OutputStream dest, String encoding) throws TransformerException {
        if (encoding == null && this.endpoint != null) {
            encoding = this.endpoint.getEncoding();
        }
        if (encoding == null) {
            encoding = MuleManager.getConfiguration().getEncoding();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Applying transformer " + this.getName() + " (" + this.getClass().getName() + ")"));
            this.logger.debug((Object)"Object before transform");
        }
        return null;
    }

    public UMOImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(UMOImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        for (UMOStreamingTransformer trans = this.nextTransformer; trans != null && endpoint != null; trans = trans.getNextTransformer()) {
            trans.setEndpoint(endpoint);
        }
    }

    protected abstract Object doTransform(InputStream var1, OutputStream var2, String var3) throws TransformerException;

    public UMOStreamingTransformer getNextTransformer() {
        return this.nextTransformer;
    }

    public void setNextTransformer(UMOStreamingTransformer nextTransformer) {
        this.nextTransformer = nextTransformer;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return BeanUtils.cloneBean((Object)this);
        }
        catch (Exception e) {
            throw (CloneNotSupportedException)new CloneNotSupportedException("Failed to clone transformer: " + e.getMessage()).initCause(e);
        }
    }

    public void initialise() throws InitialisationException {
    }

    protected String generateTransformerName() {
        String name = this.getClass().getName();
        int i = name.lastIndexOf(".");
        if (i > -1) {
            name = name.substring(i + 1);
        }
        return name;
    }

    public boolean isIgnoreBadInput() {
        return this.ignoreBadInput;
    }

    public void setIgnoreBadInput(boolean ignoreBadInput) {
        this.ignoreBadInput = ignoreBadInput;
    }

    public String toString() {
        return "StreamingTransformer{name='" + this.name + "'" + ", ignoreBadInput=" + this.ignoreBadInput + "}";
    }

    public boolean isAcceptNull() {
        return false;
    }
}

