/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.resource.spi.work.Work;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.ObjectUtils;

public abstract class AbstractPollingMessageReceiver
extends AbstractMessageReceiver
implements Work {
    public static final long DEFAULT_POLL_FREQUENCY = 1000L;
    public static final long STARTUP_DELAY = 1000L;
    protected volatile long frequency = 1000L;
    protected final List schedules = new LinkedList();

    public AbstractPollingMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, long frequency) throws InitialisationException {
        super(connector, component, endpoint);
        this.setFrequency(frequency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws UMOException {
        try {
            List list = this.schedules;
            synchronized (list) {
                ScheduledFuture schedule = this.connector.getScheduler().scheduleWithFixedDelay((Runnable)((Object)this), 1000L, this.frequency, TimeUnit.MILLISECONDS);
                this.schedules.add(schedule);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(ObjectUtils.identityToShortString(this) + " scheduled " + ObjectUtils.identityToShortString(schedule) + " with " + this.frequency + "ms polling frequency"));
                }
            }
        }
        catch (Exception ex) {
            this.stop();
            throw new InitialisationException(new Message(151), ex, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws UMOException {
        List list = this.schedules;
        synchronized (list) {
            Iterator i = this.schedules.iterator();
            while (i.hasNext()) {
                ScheduledFuture schedule = (ScheduledFuture)i.next();
                schedule.cancel(false);
                i.remove();
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)(ObjectUtils.identityToShortString(this) + " cancelled polling schedule: " + ObjectUtils.identityToShortString(schedule)));
            }
        }
    }

    public void run() {
        if (!this.stopped.get()) {
            try {
                this.connected.whenTrue(null);
                this.poll();
            }
            catch (InterruptedException e) {
                this.stop();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void release() {
        this.stop();
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long value) {
        this.frequency = value <= 0L ? 1000L : value;
    }

    public abstract void poll() throws Exception;
}

