/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.beans.ExceptionListener;
import java.io.FileInputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.config.PoolingProfile;
import org.mule.config.QueueProfile;
import org.mule.config.ThreadingProfile;
import org.mule.impl.ImmutableMuleDescriptor;
import org.mule.impl.InitialisationCallback;
import org.mule.impl.container.DescriptorContainerKeyPair;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOInterceptor;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.UMOInboundRouterCollection;
import org.mule.umo.routing.UMONestedRouterCollection;
import org.mule.umo.routing.UMOOutboundRouterCollection;
import org.mule.umo.routing.UMOResponseRouterCollection;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.FileUtils;

public class MuleDescriptor
extends ImmutableMuleDescriptor
implements UMODescriptor {
    public static final String DEFAULT_INSTANCE_REF_NAME = "_instanceRef";
    private static Log logger = LogFactory.getLog((Class)MuleDescriptor.class);

    public MuleDescriptor(String name) {
        this.name = name;
    }

    public MuleDescriptor(MuleDescriptor descriptor) {
        super(descriptor);
    }

    public MuleDescriptor() {
    }

    public void setThreadingProfile(ThreadingProfile threadingProfile) {
        this.threadingProfile = threadingProfile;
    }

    public void setExceptionListener(ExceptionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Exception Strategy cannot be null");
        }
        this.exceptionListener = listener;
        logger.debug((Object)("Using exception strategy: " + listener.getClass().getName()));
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = newName;
    }

    public void setOutboundTransformer(UMOTransformer transformer) {
        this.outboundTransformer = transformer;
    }

    public void setResponseTransformer(UMOTransformer transformer) {
        this.responseTransformer = transformer;
    }

    public void setProperties(Map props) {
        this.properties = props;
        String delegate = (String)this.properties.get("org.mule.dotProperties");
        if (delegate != null) {
            try {
                FileInputStream is = new FileInputStream(FileUtils.newFile(delegate));
                Properties dProps = new Properties();
                dProps.load(is);
                this.properties.putAll(dProps);
            }
            catch (Exception e) {
                logger.warn((Object)("org.mule.dotProperties was set  to " + delegate + " but the file could not be read, exception is: " + e.getMessage()));
            }
        }
    }

    public void setVersion(String ver) {
        this.version = ver;
    }

    public void setInboundEndpoint(UMOEndpoint endpoint) throws MuleException {
        this.inboundEndpoint = endpoint;
        if (this.inboundEndpoint != null) {
            this.inboundEndpoint.setType("receiver");
            if (this.inboundEndpoint.getTransformer() != null) {
                this.inboundTransformer = this.inboundEndpoint.getTransformer();
            }
        }
    }

    public void setOutboundEndpoint(UMOEndpoint endpoint) throws MuleException {
        this.outboundEndpoint = endpoint;
        if (this.outboundEndpoint != null) {
            this.outboundEndpoint.setType("sender");
            if (this.outboundEndpoint.getTransformer() != null) {
                this.outboundTransformer = this.outboundEndpoint.getTransformer();
            }
        }
    }

    public void setInboundTransformer(UMOTransformer transformer) {
        this.inboundTransformer = transformer;
    }

    public void addInterceptor(UMOInterceptor inteceptor) {
        if (inteceptor != null) {
            this.intecerptorList.add(inteceptor);
        }
    }

    public void setInterceptors(List inteceptorList) {
        this.intecerptorList = inteceptorList;
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    public void setImplementation(Object reference) {
        if (reference == null) {
            throw new IllegalArgumentException("ImplementationReference cannot be null");
        }
        this.implementationReference = reference;
    }

    public void setImplementationInstance(Object instance) {
        if (this.name == null) {
            throw new NullPointerException("UMODescriptor.name");
        }
        this.properties.put(DEFAULT_INSTANCE_REF_NAME, instance);
        this.setImplementation(new DescriptorContainerKeyPair(this.name, DEFAULT_INSTANCE_REF_NAME));
    }

    public void setInboundRouter(UMOInboundRouterCollection router) {
        this.inboundRouter = router;
    }

    public void setOutboundRouter(UMOOutboundRouterCollection router) {
        this.outboundRouter = router;
    }

    public void setNestedRouter(UMONestedRouterCollection router) {
        this.nestedRouter = router;
    }

    public void setContainerManaged(boolean value) {
        this.containerManaged = value;
    }

    public void addInitialisationCallback(InitialisationCallback callback) {
        this.initialisationCallbacks.add(callback);
    }

    public void setResponseRouter(UMOResponseRouterCollection router) {
        this.responseRouter = router;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setInitialState(String state) {
        this.initialState = state;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setContainer(String containerName) {
        this.container = containerName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }
}

