/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessageConstants;

public final class Messages
implements CoreMessageConstants {
    protected static final Log logger = LogFactory.getLog((Class)Messages.class);
    public static final String DEFAULT_BUNDLE = "core";
    private static final Object[] EMPTY_ARGS = new Object[0];

    private Messages() {
    }

    public static String get(int code) {
        return Messages.getString(DEFAULT_BUNDLE, code, EMPTY_ARGS);
    }

    public static String get(int code, Object[] args) {
        if (args == null) {
            args = EMPTY_ARGS;
        }
        return Messages.getString(DEFAULT_BUNDLE, code, args);
    }

    public static String get(int code, Object arg1) {
        if (arg1 == null) {
            arg1 = "null";
        }
        return Messages.getString(DEFAULT_BUNDLE, code, new Object[]{arg1});
    }

    public static String get(int code, Object arg1, Object arg2) {
        if (arg1 == null) {
            arg1 = "null";
        }
        if (arg2 == null) {
            arg2 = "null";
        }
        return Messages.getString(DEFAULT_BUNDLE, code, new Object[]{arg1, arg2});
    }

    public static String get(int code, Object arg1, Object arg2, Object arg3) {
        if (arg1 == null) {
            arg1 = "null";
        }
        if (arg2 == null) {
            arg2 = "null";
        }
        if (arg3 == null) {
            arg3 = "null";
        }
        return Messages.getString(DEFAULT_BUNDLE, code, new Object[]{arg1, arg2, arg3});
    }

    public static String get(String bundleName, int code) {
        return Messages.getString(bundleName, code, EMPTY_ARGS);
    }

    public static String get(String bundleName, int code, Object[] args) {
        if (args == null) {
            args = EMPTY_ARGS;
        }
        return Messages.getString(bundleName, code, args);
    }

    public static String get(String bundleName, int code, Object arg1) {
        if (arg1 == null) {
            arg1 = "null";
        }
        return Messages.getString(bundleName, code, new Object[]{arg1});
    }

    public static String get(String bundleName, int code, Object arg1, Object arg2) {
        if (arg1 == null) {
            arg1 = "null";
        }
        if (arg2 == null) {
            arg2 = "null";
        }
        return Messages.getString(bundleName, code, new Object[]{arg1, arg2});
    }

    public static String get(String bundleName, int code, Object arg1, Object arg2, Object arg3) {
        if (arg1 == null) {
            arg1 = "null";
        }
        if (arg2 == null) {
            arg2 = "null";
        }
        if (arg3 == null) {
            arg3 = "null";
        }
        return Messages.getString(bundleName, code, new Object[]{arg1, arg2, arg3});
    }

    public static String getString(String bundleName, int code, Object[] args) {
        ResourceBundle bundle = Messages.getBundle(bundleName);
        try {
            String m = bundle.getString(String.valueOf(code));
            if (m == null) {
                logger.error((Object)("Failed to find message for id " + code + " in resource bundle " + bundleName));
                return "";
            }
            return MessageFormat.format(m, args);
        }
        catch (MissingResourceException e) {
            logger.error((Object)("Failed to find message for id " + code + " in resource bundle " + bundleName));
            return "";
        }
    }

    protected static ResourceBundle getBundle(String bundleName) {
        String path = "META-INF.services.org.mule.i18n." + bundleName + "-messages";
        logger.debug((Object)("Loading resource bundle: " + path + " for locale " + Locale.getDefault()));
        Locale locale = Locale.getDefault();
        ResourceBundle bundle = ResourceBundle.getBundle(path, locale);
        return bundle;
    }
}

