/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingDeque;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.SynchronousQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.mule.impl.work.MuleWorkManager;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.util.concurrent.NamedThreadFactory;
import org.mule.util.concurrent.WaitPolicy;

public class ThreadingProfile {
    public static final int DEFAULT_MAX_THREADS_ACTIVE = 8;
    public static final int DEFAULT_MAX_THREADS_IDLE = 1;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 0;
    public static final long DEFAULT_MAX_THREAD_TTL = 60000L;
    public static final long DEFAULT_THREAD_WAIT_TIMEOUT = 30000L;
    public static final boolean DEFAULT_DO_THREADING = true;
    public static final int WHEN_EXHAUSTED_WAIT = 0;
    public static final int WHEN_EXHAUSTED_DISCARD = 1;
    public static final int WHEN_EXHAUSTED_DISCARD_OLDEST = 2;
    public static final int WHEN_EXHAUSTED_ABORT = 3;
    public static final int WHEN_EXHAUSTED_RUN = 4;
    public static final int DEFAULT_POOL_EXHAUST_ACTION = 4;
    private int maxThreadsActive = 8;
    private int maxThreadsIdle = 1;
    private int maxBufferSize = 0;
    private long threadTTL = 60000L;
    private long threadWaitTimeout = 30000L;
    private int poolExhaustPolicy = 4;
    private boolean doThreading = true;
    private WorkManagerFactory workManagerFactory = new DefaultWorkManagerFactory();
    private RejectedExecutionHandler rejectedExecutionHandler;
    private ThreadFactory threadFactory;

    public ThreadingProfile() {
    }

    public ThreadingProfile(int maxThreadsActive, int maxThreadsIdle, long threadTTL, int poolExhaustPolicy, RejectedExecutionHandler rejectedExecutionHandler, ThreadFactory threadFactory) {
        this.maxThreadsActive = maxThreadsActive;
        this.maxThreadsIdle = maxThreadsIdle;
        this.threadTTL = threadTTL;
        this.poolExhaustPolicy = poolExhaustPolicy;
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        this.threadFactory = threadFactory;
    }

    public ThreadingProfile(ThreadingProfile tp) {
        this.maxThreadsActive = tp.getMaxThreadsActive();
        this.maxThreadsIdle = tp.getMaxThreadsIdle();
        this.maxBufferSize = tp.getMaxBufferSize();
        this.threadTTL = tp.getThreadTTL();
        this.threadWaitTimeout = tp.getThreadWaitTimeout();
        this.poolExhaustPolicy = tp.getPoolExhaustedAction();
        this.doThreading = tp.isDoThreading();
        this.rejectedExecutionHandler = tp.getRejectedExecutionHandler();
        this.threadFactory = tp.getThreadFactory();
        this.workManagerFactory = tp.getWorkManagerFactory();
    }

    public int getMaxThreadsActive() {
        return this.maxThreadsActive;
    }

    public int getMaxThreadsIdle() {
        return this.maxThreadsIdle;
    }

    public long getThreadTTL() {
        return this.threadTTL;
    }

    public long getThreadWaitTimeout() {
        return this.threadWaitTimeout;
    }

    public int getPoolExhaustedAction() {
        return this.poolExhaustPolicy;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setMaxThreadsActive(int maxThreadsActive) {
        this.maxThreadsActive = maxThreadsActive;
    }

    public void setMaxThreadsIdle(int maxThreadsIdle) {
        this.maxThreadsIdle = maxThreadsIdle;
    }

    public void setThreadTTL(long threadTTL) {
        this.threadTTL = threadTTL;
    }

    public void setThreadWaitTimeout(long threadWaitTimeout) {
        this.threadWaitTimeout = threadWaitTimeout;
    }

    public void setPoolExhaustedAction(int poolExhaustPolicy) {
        this.poolExhaustPolicy = poolExhaustPolicy;
    }

    public void setPoolExhaustedActionString(String poolExhaustPolicy) {
        if (poolExhaustPolicy != null) {
            this.poolExhaustPolicy = "WAIT".equals(poolExhaustPolicy) ? 0 : ("ABORT".equals(poolExhaustPolicy) ? 3 : ("DISCARD".equals(poolExhaustPolicy) ? 1 : ("DISCARD_OLDEST".equals(poolExhaustPolicy) ? 2 : 4)));
        }
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public WorkManagerFactory getWorkManagerFactory() {
        return this.workManagerFactory;
    }

    public void setWorkManagerFactory(WorkManagerFactory workManagerFactory) {
        this.workManagerFactory = workManagerFactory;
    }

    public UMOWorkManager createWorkManager(String name) {
        return this.workManagerFactory.createWorkManager(this, name);
    }

    public ThreadPoolExecutor createPool() {
        return this.createPool(null);
    }

    public ThreadPoolExecutor createPool(String name) {
        Object buffer = this.maxBufferSize > 0 && this.maxThreadsActive > 1 ? new LinkedBlockingDeque(this.maxBufferSize) : new SynchronousQueue();
        if (this.maxThreadsIdle > this.maxThreadsActive) {
            this.maxThreadsIdle = this.maxThreadsActive;
        }
        ThreadPoolExecutor pool = new ThreadPoolExecutor(this.maxThreadsIdle, this.maxThreadsActive, this.threadTTL, TimeUnit.MILLISECONDS, (BlockingQueue)buffer);
        ThreadFactory tf = this.threadFactory;
        if (name != null) {
            tf = new NamedThreadFactory(name);
        }
        if (tf != null) {
            pool.setThreadFactory(tf);
        }
        if (this.rejectedExecutionHandler != null) {
            pool.setRejectedExecutionHandler(this.rejectedExecutionHandler);
        } else {
            switch (this.poolExhaustPolicy) {
                case 2: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy());
                    break;
                }
                case 4: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
                    break;
                }
                case 3: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
                    break;
                }
                case 1: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
                    break;
                }
                case 0: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new WaitPolicy(this.threadWaitTimeout, TimeUnit.MILLISECONDS));
                    break;
                }
                default: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new WaitPolicy(this.threadWaitTimeout, TimeUnit.MILLISECONDS));
                }
            }
        }
        return pool;
    }

    public boolean isDoThreading() {
        return this.doThreading;
    }

    public void setDoThreading(boolean doThreading) {
        this.doThreading = doThreading;
    }

    public String toString() {
        return "ThreadingProfile{maxThreadsActive=" + this.maxThreadsActive + ", maxThreadsIdle=" + this.maxThreadsIdle + ", maxBufferSize=" + this.maxBufferSize + ", threadTTL=" + this.threadTTL + ", poolExhaustPolicy=" + this.poolExhaustPolicy + ", threadWaitTimeout=" + this.threadWaitTimeout + ", doThreading=" + this.doThreading + ", workManagerFactory=" + this.workManagerFactory + ", rejectedExecutionHandler=" + this.rejectedExecutionHandler + ", threadFactory=" + this.threadFactory + "}";
    }

    private class DefaultWorkManagerFactory
    implements WorkManagerFactory {
        private DefaultWorkManagerFactory() {
        }

        public UMOWorkManager createWorkManager(ThreadingProfile profile, String name) {
            return new MuleWorkManager(profile, name);
        }
    }

    public static interface WorkManagerFactory {
        public UMOWorkManager createWorkManager(ThreadingProfile var1, String var2);
    }
}

