/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.Message;
import org.mule.util.IOUtils;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void copyStreamToFile(InputStream input, File destination) throws IOException {
        if (destination.exists() && !destination.canWrite()) {
            throw new IOException("Destination file does not exist or is not writeable");
        }
        try {
            FileOutputStream output = new FileOutputStream(destination);
            try {
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static File createFile(String filename) throws IOException {
        File file = FileUtils.newFile(filename);
        if (!file.canWrite()) {
            String dirName = file.getPath();
            int i = dirName.lastIndexOf(File.separator);
            if (i > -1) {
                dirName = dirName.substring(0, i);
                File dir = FileUtils.newFile(dirName);
                dir.mkdirs();
            }
            file.createNewFile();
        }
        return file;
    }

    public static String prepareWinFilename(String filename) {
        filename = filename.replaceAll("<", "(");
        filename = filename.replaceAll(">", ")");
        filename = filename.replaceAll("[/\\*?|:;\\]\\[\"]", "-");
        return filename;
    }

    public static File openDirectory(String directory) throws IOException {
        File dir = FileUtils.newFile(directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory() || !dir.canRead()) {
            throw new IOException("Path: " + directory + " exists but isn't a directory");
        }
        return dir;
    }

    public static File stringToFile(String filename, String data) throws IOException {
        return FileUtils.stringToFile(filename, data, false);
    }

    public static synchronized File stringToFile(String filename, String data, boolean append) throws IOException {
        return FileUtils.stringToFile(filename, data, append, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized File stringToFile(String filename, String data, boolean append, boolean newLine) throws IOException {
        File f = FileUtils.createFile(filename);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(f, append));
            writer.write(data);
            if (newLine) {
                writer.newLine();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }

    public static String getResourcePath(String resourceName, Class callingClass) throws IOException {
        return FileUtils.getResourcePath(resourceName, callingClass, MuleManager.getConfiguration().getEncoding());
    }

    public static String getResourcePath(String resourceName, Class callingClass, String encoding) throws IOException {
        if (resourceName == null) {
            return null;
        }
        URL url = IOUtils.getResourceAsUrl(resourceName, callingClass);
        if (url == null) {
            return null;
        }
        String resource = URLDecoder.decode(url.toExternalForm(), encoding);
        if (resource != null) {
            if (resource.startsWith("file:/")) {
                resource = resource.substring(6);
            }
            if (!resource.startsWith(File.separator)) {
                resource = File.separator + resource;
            }
        }
        return resource;
    }

    public static boolean deleteTree(File dir) {
        if (dir == null || !dir.exists()) {
            return true;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!(files[i].isDirectory() ? !FileUtils.deleteTree(files[i]) : !files[i].delete())) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File archive, File directory) throws IOException {
        ZipFile zip = null;
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IOException("Directory is not a directory: " + directory);
            }
        } else if (!directory.mkdirs()) {
            throw new IOException("Could not create directory: " + directory);
        }
        try {
            zip = new ZipFile(archive);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File f = new File(directory, entry.getName());
                if (entry.isDirectory()) {
                    if (f.mkdirs()) continue;
                    throw new IOException("Could not create directory: " + f);
                }
                InputStream is = zip.getInputStream(entry);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
                IOUtils.copy((InputStream)is, (OutputStream)os);
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
    }

    public static File newFile(String pathName) {
        try {
            return new File(pathName).getCanonicalFile();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(Message.createStaticMessage("Unable to create a canonical file for " + pathName), (Throwable)e);
        }
    }

    public static File newFile(URI uri) {
        try {
            return new File(uri).getCanonicalFile();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(Message.createStaticMessage("Unable to create a canonical file for " + uri), (Throwable)e);
        }
    }

    public static File newFile(File parent, String child) {
        try {
            return new File(parent, child).getCanonicalFile();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(Message.createStaticMessage("Unable to create a canonical file for parent: " + parent + " and child: " + child), (Throwable)e);
        }
    }

    public static File newFile(String parent, String child) {
        try {
            return new File(parent, child).getCanonicalFile();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(Message.createStaticMessage("Unable to create a canonical file for parent: " + parent + " and child: " + child), (Throwable)e);
        }
    }
}

