/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOTransaction;

public class TransactionCoordination {
    protected static final Log logger = LogFactory.getLog((Class)TransactionCoordination.class);
    private static volatile TransactionCoordination instance;
    private final ThreadLocal transactions = new ThreadLocal();
    private int txCounter = 0;

    private TransactionCoordination() {
    }

    public static TransactionCoordination getInstance() {
        if (instance == null) {
            TransactionCoordination.setInstance(new TransactionCoordination());
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setInstance(TransactionCoordination txSync) {
        if (instance == null) {
            instance = txSync;
        }
        TransactionCoordination transactionCoordination = instance;
        synchronized (transactionCoordination) {
            if (TransactionCoordination.instance.txCounter != 0) {
                throw new IllegalStateException("there are currently " + TransactionCoordination.instance.txCounter + "transactions associated with this manager, cannot replace the manager");
            }
        }
    }

    public UMOTransaction getTransaction() {
        return (UMOTransaction)this.transactions.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindTransaction(UMOTransaction transaction) throws TransactionException {
        TransactionCoordination transactionCoordination;
        try {
            UMOTransaction oldTx = (UMOTransaction)this.transactions.get();
            if (oldTx != null && !oldTx.equals(transaction)) {
                throw new IllegalTransactionStateException(new Message(107));
            }
            Object var4_3 = null;
            this.transactions.set(null);
            transactionCoordination = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.transactions.set(null);
            TransactionCoordination transactionCoordination2 = this;
            synchronized (transactionCoordination2) {
                if (this.txCounter > 0) {
                    --this.txCounter;
                }
            }
            throw throwable;
        }
        synchronized (transactionCoordination) {
            if (this.txCounter > 0) {
                --this.txCounter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindTransaction(UMOTransaction transaction) throws TransactionException {
        UMOTransaction oldTx = (UMOTransaction)this.transactions.get();
        if (oldTx != null) {
            throw new IllegalTransactionStateException(new Message(108));
        }
        this.transactions.set(transaction);
        TransactionCoordination transactionCoordination = this;
        synchronized (transactionCoordination) {
            ++this.txCounter;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Binding new transaction (" + this.txCounter + ")"));
            }
        }
    }
}

