/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mule.routing.outbound.AbstractRecipientList;
import org.mule.umo.UMOMessage;
import org.mule.util.StringUtils;

public class StaticRecipientList
extends AbstractRecipientList {
    public static final String RECIPIENTS_PROPERTY = "recipients";
    public static final String RECIPIENT_DELIMITER = ",";
    private volatile CopyOnWriteArrayList recipients = new CopyOnWriteArrayList();

    protected List getRecipients(UMOMessage message) {
        Object msgRecipients = message.removeProperty(RECIPIENTS_PROPERTY);
        if (msgRecipients == null) {
            return this.recipients;
        }
        if (msgRecipients instanceof String) {
            return new CopyOnWriteArrayList((Object[])StringUtils.splitAndTrim(msgRecipients.toString(), this.getListDelimiter()));
        }
        if (msgRecipients instanceof List) {
            return new CopyOnWriteArrayList((Collection)((List)msgRecipients));
        }
        this.logger.warn((Object)("Recipients on message are neither String nor List but: " + msgRecipients.getClass()));
        return Collections.EMPTY_LIST;
    }

    public List getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List recipients) {
        this.recipients = recipients != null ? new CopyOnWriteArrayList((Collection)recipients) : null;
    }

    protected String getListDelimiter() {
        return RECIPIENT_DELIMITER;
    }
}

