/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.impl.MuleMessage;
import org.mule.routing.outbound.AbstractMessageSplitter;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;

public class FilteringListMessageSplitter
extends AbstractMessageSplitter {
    private static ThreadLocal payloads = new ThreadLocal();
    private static ThreadLocal properties = new ThreadLocal();

    protected void initialise(UMOMessage message) {
        if (message.getPayload() instanceof List) {
            CopyOnWriteArrayList payload = new CopyOnWriteArrayList((Collection)((List)message.getPayload()));
            payloads.set(payload);
            if (this.enableCorrelation != 2) {
                int groupSize = payload.size();
                message.setCorrelationGroupSize(groupSize);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("java.util.List payload detected, setting correlation group size to " + groupSize));
                }
            }
        } else {
            throw new IllegalArgumentException("The payload for this router must be of type java.util.List");
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        Iterator iterator = message.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String propertyKey = (String)iterator.next();
            props.put(propertyKey, message.getProperty(propertyKey));
        }
        properties.set(props);
    }

    protected UMOMessage getMessagePart(UMOMessage message, UMOEndpoint endpoint) {
        CopyOnWriteArrayList payload = (CopyOnWriteArrayList)payloads.get();
        for (int i = 0; i < payload.size(); ++i) {
            Object object = payload.get(i);
            MuleMessage result = new MuleMessage(object, (Map)properties.get());
            if (endpoint.getFilter() != null && !endpoint.getFilter().accept(result)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Endpoint filter matched. Routing message over: " + endpoint.getEndpointURI().toString()));
            }
            payload.remove(i);
            return result;
        }
        return null;
    }
}

