/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.routing.AbstractRouterCollection;
import org.mule.routing.inbound.InboundPassThroughRouter;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.routing.UMOInboundMessageRouter;
import org.mule.umo.routing.UMOInboundRouter;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;

public class InboundMessageRouter
extends AbstractRouterCollection
implements UMOInboundMessageRouter {
    protected static Log logger = LogFactory.getLog((Class)InboundMessageRouter.class);
    private List endpoints = new CopyOnWriteArrayList();

    public InboundMessageRouter() {
        super(1);
    }

    public UMOMessage route(UMOEvent event) throws MessagingException {
        String inboundEndpoint = event.getEndpoint().getName();
        if (StringUtils.isBlank((String)inboundEndpoint)) {
            inboundEndpoint = event.getEndpoint().getEndpointURI().getAddress();
        }
        event.getMessage().setProperty("MULE_ORIGINATING_ENDPOINT", inboundEndpoint);
        if (this.endpoints.size() > 0 && this.routers.size() == 0) {
            this.addRouter(new InboundPassThroughRouter());
        }
        String componentName = event.getSession().getComponent().getDescriptor().getName();
        UMOEvent[] eventsToRoute = null;
        boolean noRoute = true;
        boolean match = false;
        UMOInboundRouter umoInboundRouter = null;
        Iterator iterator = this.getRouters().iterator();
        while (iterator.hasNext()) {
            umoInboundRouter = (UMOInboundRouter)iterator.next();
            if (!umoInboundRouter.isMatch(event)) continue;
            match = true;
            eventsToRoute = umoInboundRouter.process(event);
            boolean bl = noRoute = eventsToRoute == null;
            if (this.matchAll) continue;
        }
        if (!event.isStopFurtherProcessing()) {
            if (noRoute) {
                if (this.getStatistics().isEnabled()) {
                    this.getStatistics().incrementNoRoutedMessage();
                }
                if (!match) {
                    if (this.getCatchAllStrategy() != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Message did not match any routers on: " + componentName + " - invoking catch all strategy"));
                        }
                        if (this.getStatistics().isEnabled()) {
                            this.getStatistics().incrementCaughtMessage();
                        }
                        return this.getCatchAllStrategy().catchMessage(event.getMessage(), event.getSession(), event.isSynchronous());
                    }
                    logger.warn((Object)("Message did not match any routers on: " + componentName + " and there is no catch all strategy configured on this router.  Disposing message."));
                    if (logger.isDebugEnabled()) {
                        try {
                            logger.warn((Object)("Message fragment is: " + StringMessageUtils.truncate(event.getMessageAsString(), 100, true)));
                        }
                        catch (UMOException e) {}
                    }
                }
            } else {
                try {
                    UMOMessage messageResult = null;
                    if (eventsToRoute != null) {
                        for (int i = 0; i < eventsToRoute.length; ++i) {
                            if (event.getMessage().getProperty("MULE_ORIGINATING_ENDPOINT") == null) {
                                event.getMessage().setProperty("MULE_ORIGINATING_ENDPOINT", inboundEndpoint);
                            }
                            if (event.isSynchronous()) {
                                messageResult = this.send(eventsToRoute[i]);
                            } else {
                                this.dispatch(eventsToRoute[i]);
                            }
                            if (!this.getStatistics().isEnabled()) continue;
                            this.getStatistics().incrementRoutedMessage(eventsToRoute[i].getEndpoint());
                        }
                    }
                    return messageResult;
                }
                catch (UMOException e) {
                    throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)e);
                }
            }
        }
        return eventsToRoute != null && eventsToRoute.length > 0 ? eventsToRoute[eventsToRoute.length - 1].getMessage() : null;
    }

    public void dispatch(UMOEvent event) throws UMOException {
        event.getSession().dispatchEvent(event);
    }

    public UMOMessage send(UMOEvent event) throws UMOException {
        return event.getSession().sendEvent(event);
    }

    public void addRouter(UMOInboundRouter router) {
        this.routers.add(router);
    }

    public UMOInboundRouter removeRouter(UMOInboundRouter router) {
        if (this.routers.remove(router)) {
            return router;
        }
        return null;
    }

    public void addEndpoint(UMOEndpoint endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint = null");
        }
        endpoint.setType("receiver");
        this.endpoints.add(endpoint);
    }

    public boolean removeEndpoint(UMOEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        if (endpoints != null) {
            this.endpoints.clear();
            this.endpoints.addAll(endpoints);
            Iterator it = this.endpoints.iterator();
            while (it.hasNext()) {
                ((UMOEndpoint)it.next()).setType("receiver");
            }
        } else {
            throw new NullPointerException("List of endpoints = null");
        }
    }

    public UMOEndpoint getEndpoint(String name) {
        Iterator iterator = this.endpoints.iterator();
        while (iterator.hasNext()) {
            UMOEndpoint endpointDescriptor = (UMOEndpoint)iterator.next();
            if (!endpointDescriptor.getName().equals(name)) continue;
            return endpointDescriptor;
        }
        return null;
    }
}

