/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model;

import [Ljava.lang.Object;;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.model.NoSatisfiableMethodsException;
import org.mule.model.TooManySatisfiableMethodsException;
import org.mule.providers.NullPayload;
import org.mule.umo.UMOEventContext;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.model.UMOEntryPoint;
import org.mule.util.ClassUtils;

public class DynamicEntryPoint
implements UMOEntryPoint {
    protected static final Log logger = LogFactory.getLog((Class)DynamicEntryPoint.class);
    private Map entryPoints = new HashMap();
    private Method currentMethod;
    protected String[] ignoreMethods = new String[]{"equals", "getInvocationHandler"};

    public Class[] getParameterTypes() {
        if (this.currentMethod == null) {
            return null;
        }
        return this.currentMethod.getParameterTypes();
    }

    public synchronized Object invoke(Object component, UMOEventContext context) throws Exception {
        boolean ignore;
        Object payload = null;
        Method method = null;
        Boolean ignoreMethod = (Boolean)context.getMessage().removeProperty("MULE_IGNORE_METHOD");
        boolean bl = ignore = ignoreMethod == null ? false : ignoreMethod;
        if (!ignore) {
            Object methodOverride = context.getMessage().removeProperty("method");
            if (methodOverride instanceof Method) {
                method = (Method)methodOverride;
            } else if (methodOverride != null) {
                payload = context.getTransformedMessage();
                method = ClassUtils.getMethod(methodOverride.toString(), ClassUtils.getClassTypes(payload), component.getClass());
                this.validateMethod(component, method, methodOverride.toString());
            }
        }
        if (method == null) {
            if (component instanceof Callable) {
                method = Callable.class.getMethods()[0];
                payload = context;
            }
            if (method == null) {
                method = this.getMethod(component, context);
                if (method == null) {
                    payload = context.getTransformedMessage();
                    method = this.getMethod(component, payload);
                    if (method != null) {
                        RequestContext.rewriteEvent(new MuleMessage(payload, context.getMessage()));
                    }
                } else {
                    payload = context;
                }
            }
        }
        if (method != null) {
            this.validateMethod(component, method, method.getName());
            this.currentMethod = method;
            if (payload == null) {
                payload = context.getTransformedMessage();
                RequestContext.rewriteEvent(new MuleMessage(payload, context.getMessage()));
            }
            return this.invokeCurrent(component, payload);
        }
        List methods = ClassUtils.getSatisfiableMethods(component.getClass(), ClassUtils.getClassTypes(context), true, false, this.ignoreMethods);
        if (methods.size() > 1) {
            TooManySatisfiableMethodsException tmsmex = new TooManySatisfiableMethodsException(component.getClass());
            throw new InvocationTargetException(tmsmex, "There must be only one method accepting " + context.getClass().getName() + " in component " + component.getClass().getName());
        }
        if (methods.size() == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Dynamic Entrypoint using method: " + component.getClass().getName() + "." + ((Method)methods.get(0)).getName() + "(" + context.getClass().getName() + ")"));
            }
            this.addMethod(component, (Method)methods.get(0), context.getClass());
            return this.invokeCurrent(component, context);
        }
        methods = ClassUtils.getSatisfiableMethods(component.getClass(), ClassUtils.getClassTypes(payload), true, true, this.ignoreMethods);
        if (methods.size() > 1) {
            throw new TooManySatisfiableMethodsException(component.getClass());
        }
        if (methods.size() == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Dynamic Entrypoint using method: " + component.getClass().getName() + "." + ((Method)methods.get(0)).getName() + "(" + payload.getClass().getName() + ")"));
            }
            this.addMethod(component, (Method)methods.get(0), payload.getClass());
            return this.invokeCurrent(component, payload);
        }
        throw new NoSatisfiableMethodsException(component.getClass(), ClassUtils.getClassTypes(payload));
    }

    protected void validateMethod(Object component, Method method, String methodName) throws Exception {
        block3: {
            boolean fallback = component instanceof Callable;
            if (method == null && !fallback) {
                throw new NoSuchMethodException(new Message(109, methodName, (Object)"unknown", (Object)component.getClass().getName()).toString());
            }
            try {
                component.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception e) {
                if (fallback) break block3;
                throw e;
            }
        }
    }

    protected Method getMethod(Object component, Object arg) {
        return (Method)this.entryPoints.get(component.getClass().getName() + ":" + arg.getClass().getName());
    }

    protected void addMethod(Object component, Method method, Class arg) {
        this.entryPoints.put(component.getClass().getName() + ":" + arg.getName(), method);
        this.currentMethod = method;
    }

    private Object invokeCurrent(Object component, Object arg) throws InvocationTargetException, IllegalAccessException {
        String methodCall = null;
        if (logger.isDebugEnabled()) {
            methodCall = component.getClass().getName() + "." + this.currentMethod.getName() + "(" + arg.getClass().getName() + ")";
            logger.debug((Object)("Invoking " + methodCall));
        }
        Object[] args = arg.getClass().isArray() ? (Object;.class.isAssignableFrom(arg.getClass()) ? (Object[])arg : new Object[]{arg}) : (arg instanceof NullPayload ? null : new Object[]{arg});
        Object result = this.currentMethod.invoke(component, args);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result of call " + methodCall + " is " + (result == null ? "null" : "not null")));
        }
        return result;
    }

    public boolean isVoid() {
        if (this.currentMethod == null) {
            return false;
        }
        return this.currentMethod.getReturnType().getName().equals("void");
    }

    public String getMethodName() {
        if (this.currentMethod == null) {
            return null;
        }
        return this.currentMethod.getName();
    }
}

