/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.security;

import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.mule.config.i18n.Message;
import org.mule.impl.security.AbstractJCEEncryptionStrategy;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.ObjectFactory;
import org.mule.util.StringMessageUtils;

public class SecretKeyEncryptionStrategy
extends AbstractJCEEncryptionStrategy {
    public static final String DEFAULT_ALGORITHM = "Blowfish";
    private byte[] key;
    private ObjectFactory keyFactory;

    public SecretKeyEncryptionStrategy() {
        this.algorithm = DEFAULT_ALGORITHM;
    }

    public void initialise() throws InitialisationException {
        if (this.key == null) {
            if (this.keyFactory == null) {
                throw new InitialisationException(new Message(45, "Key / KeyFactory"), (Object)this);
            }
            try {
                this.key = (byte[])this.keyFactory.create();
            }
            catch (Exception e) {
                throw new InitialisationException(e, (Object)this);
            }
        }
        super.initialise();
    }

    protected KeySpec createKeySpec() {
        return new SecretKeySpec(this.key, this.algorithm);
    }

    protected AlgorithmParameterSpec createAlgorithmParameterSpec() {
        return null;
    }

    public void setKey(byte[] rawKey) {
        this.key = rawKey;
    }

    public void setKey(String rawKey) {
        this.key = StringMessageUtils.getBytes(rawKey);
    }

    public ObjectFactory getKeyFactory() {
        return this.keyFactory;
    }

    public void setKeyFactory(ObjectFactory keyFactory) {
        this.keyFactory = keyFactory;
    }

    protected SecretKey getSecretKey() throws GeneralSecurityException {
        return KeyGenerator.getInstance(this.algorithm).generateKey();
    }
}

