/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;

public class NamedThreadFactory
implements ThreadFactory {
    private final String name;
    private final int priority;
    private final AtomicLong counter;

    public NamedThreadFactory(String name) {
        this(name, 5);
    }

    public NamedThreadFactory(String name, int priority) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("NamedThreadFactory must have a proper name.");
        }
        this.name = name;
        this.priority = priority;
        this.counter = new AtomicLong(1L);
    }

    public Thread newThread(Runnable runnable) {
        Thread t = new Thread(runnable, this.name + '.' + this.counter.getAndIncrement());
        t.setPriority(this.priority);
        return t;
    }
}

