/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOConnector;

public class ObjectNameHelper {
    public static final String SEPARATOR = ".";
    public static final char HASH = '#';
    public static final String CONNECTOR_PREFIX = "connector";
    public static final String ENDPOINT_PREFIX = "endpoint";
    static Log logger = LogFactory.getLog((Class)ObjectNameHelper.class);

    public static String getEndpointName(UMOImmutableEndpoint endpoint) {
        String name = endpoint.getName();
        if (name != null) {
            if (name.equals(endpoint.getEndpointURI().getAddress())) {
                name = endpoint.getEndpointURI().getScheme() + SEPARATOR + name;
            }
            name = ObjectNameHelper.replaceObjectNameChars(name);
            return name;
        }
        String address = endpoint.getEndpointURI().getAddress();
        address = address.indexOf(":/") > -1 ? address : endpoint.getEndpointURI().getScheme() + SEPARATOR + address;
        name = "endpoint." + ObjectNameHelper.replaceObjectNameChars(address);
        return ObjectNameHelper.ensureUniqueEndpoint(name);
    }

    protected static String ensureUniqueEndpoint(String name) {
        int i = 0;
        String tempName = name;
        while (MuleManager.getInstance().lookupEndpoint(tempName) != null) {
            tempName = name + SEPARATOR + ++i;
        }
        return tempName;
    }

    protected static String ensureUniqueConnector(String name) {
        int i = 0;
        String tempName = name;
        while (MuleManager.getInstance().lookupConnector(tempName) != null) {
            tempName = name + SEPARATOR + ++i;
        }
        return tempName;
    }

    public static String getConnectorName(UMOConnector connector) {
        if (connector.getName() != null && connector.getName().indexOf("#") == -1) {
            String name = ObjectNameHelper.replaceObjectNameChars(connector.getName());
            return ObjectNameHelper.ensureUniqueConnector(name);
        }
        int i = 0;
        String name = "connector." + connector.getProtocol() + SEPARATOR + i;
        return ObjectNameHelper.ensureUniqueConnector(name);
    }

    public static String replaceObjectNameChars(String name) {
        String value = name.replaceAll("//", SEPARATOR);
        value = value.replaceAll("\\p{Punct}", SEPARATOR);
        if ((value = value.replaceAll("\\.{2,}", SEPARATOR)).endsWith(SEPARATOR)) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }
}

