/*
 * Decompiled with CFR 0.152.
 */
package org.mule.umo.manager;

import java.util.EventObject;
import org.mule.MuleManager;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.util.ClassUtils;

public abstract class UMOServerNotification
extends EventObject {
    public static final String TYPE_INFO = "info";
    public static final String TYPE_WARNING = "warn";
    public static final String TYPE_ERROR = "error";
    public static final String TYPE_FATAL = "fatal";
    public static final int MANAGER_EVENT_ACTION_START_RANGE = 100;
    public static final int MODEL_EVENT_ACTION_START_RANGE = 200;
    public static final int COMPONENT_EVENT_ACTION_START_RANGE = 300;
    public static final int SECURITY_EVENT_ACTION_START_RANGE = 400;
    public static final int MANAGEMENT_EVENT_ACTION_START_RANGE = 500;
    public static final int ADMIN_EVENT_ACTION_START_RANGE = 600;
    public static final int CONNECTION_EVENT_ACTION_START_RANGE = 700;
    public static final int MESSAGE_EVENT_ACTION_START_RANGE = 800;
    public static final int SPACE_EVENT_ACTION_START_RANGE = 900;
    public static final int REGISTRY_EVENT_ACTION_START_RANGE = 1000;
    public static final int CUSTOM_EVENT_ACTION_START_RANGE = 100000;
    public static final int NULL_ACTION = 0;
    public static final Object NULL_MESSAGE = new Object();
    public final String EVENT_NAME = ClassUtils.getClassName(this.getClass());
    protected String serverId;
    protected long timestamp;
    protected int action = 0;
    protected String resourceIdentifier = null;

    public UMOServerNotification(Object message, int action) {
        super(message == null ? NULL_MESSAGE : message);
        this.action = action;
        if (MuleManager.isInstanciated()) {
            this.serverId = MuleManager.getInstance().getId();
        }
        this.timestamp = System.currentTimeMillis();
    }

    public UMOServerNotification(Object message, int action, String resourceIdentifier) {
        super(message == null ? NULL_MESSAGE : message);
        this.action = action;
        this.resourceIdentifier = resourceIdentifier;
        this.serverId = MuleManager.getInstance().getId();
        this.timestamp = System.currentTimeMillis();
    }

    public int getAction() {
        return this.action;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isResourceIdentifierAnUri() {
        return MuleEndpointURI.isMuleUri(this.resourceIdentifier);
    }

    public String toString() {
        return this.EVENT_NAME + "{" + "action=" + this.getActionName(this.action) + ", resourceId=" + this.resourceIdentifier + ", serverId=" + this.serverId + ", timestamp=" + this.timestamp + "}";
    }

    protected String getPayloadToString() {
        return this.source.toString();
    }

    public String getType() {
        return TYPE_INFO;
    }

    public String getActionName() {
        return this.getActionName(this.action);
    }

    protected abstract String getActionName(int var1);
}

