/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.wire;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.transformers.wire.WireFormat;
import org.mule.umo.UMOException;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.IOUtils;

public class TransformerPairWireFormat
implements WireFormat {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected UMOTransformer inboundTransformer;
    protected UMOTransformer outboundTransformer;

    public Object read(InputStream in) throws UMOException {
        if (this.inboundTransformer == null) {
            throw new NullPointerException(new Message(45, "inboundTransformer").getMessage());
        }
        if (this.inboundTransformer.isSourceTypeSupported(InputStream.class)) {
            return this.inboundTransformer.transform(in);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)baos);
            return this.inboundTransformer.transform(baos.toByteArray());
        }
        catch (IOException e) {
            throw new MuleException(new Message(124, e));
        }
    }

    public void write(OutputStream out, Object o) throws UMOException {
        block6: {
            if (this.outboundTransformer == null) {
                throw new NullPointerException(new Message(45, "outboundTransformer").getMessage());
            }
            try {
                Class returnClass = this.outboundTransformer.getReturnClass();
                if (returnClass == null) {
                    this.logger.warn((Object)("No return class was set on transformer: " + this.outboundTransformer + ". Attempting to work out" + "how to treat the result transformation"));
                    Object result = this.outboundTransformer.transform(o);
                    byte[] bytes = result instanceof byte[] ? (byte[])result : result.toString().getBytes(MuleManager.getConfiguration().getEncoding());
                    out.write(bytes);
                    break block6;
                }
                if (returnClass.equals([B.class)) {
                    byte[] b = (byte[])this.outboundTransformer.transform(o);
                    out.write(b);
                    break block6;
                }
                if (returnClass != null && returnClass.equals(String.class)) {
                    String s = (String)this.outboundTransformer.transform(o);
                    out.write(s.getBytes(MuleManager.getConfiguration().getEncoding()));
                    break block6;
                }
                throw new TransformerException(new Message(55, o.getClass()));
            }
            catch (IOException e) {
                throw new TransformerException(new Message(55, o.getClass(), (Object)e));
            }
        }
    }

    public UMOTransformer getInboundTransformer() {
        return this.inboundTransformer;
    }

    public void setInboundTransformer(UMOTransformer inboundTransformer) {
        this.inboundTransformer = inboundTransformer;
    }

    public UMOTransformer getOutboundTransformer() {
        return this.outboundTransformer;
    }

    public void setOutboundTransformer(UMOTransformer outboundTransformer) {
        this.outboundTransformer = outboundTransformer;
    }
}

