/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractConnectionStrategy;
import org.mule.providers.FatalConnectException;
import org.mule.umo.provider.UMOConnectable;

public class SimpleRetryConnectionStrategy
extends AbstractConnectionStrategy {
    private static final ThreadLocal count = new ThreadLocal(){

        protected Object initialValue() {
            return new AtomicInteger(0);
        }
    };
    private int retryCount = 2;
    private long frequency = 2000L;

    public void doConnect(UMOConnectable connectable) throws FatalConnectException {
        while (true) {
            int currentCount = ((AtomicInteger)count.get()).incrementAndGet();
            try {
                connectable.connect();
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug((Object)("Successfully connected to " + this.getDescription(connectable)));
                break;
            }
            catch (InterruptedException ie) {
                throw new FatalConnectException(new Message(164, this.getClass().getName(), (Object)this.getDescription(connectable)), ie, connectable);
            }
            catch (Exception e) {
                if (currentCount == this.retryCount) {
                    throw new FatalConnectException(new Message(164, this.getClass().getName(), (Object)this.getDescription(connectable)), e, connectable);
                }
                if (this.logger.isErrorEnabled()) {
                    StringBuffer msg = new StringBuffer(512);
                    msg.append("Failed to connect/reconnect on endpoint: ").append(this.getDescription(connectable));
                    Throwable t = ExceptionHelper.getRootException(e);
                    msg.append(". Root Exception was: ").append(ExceptionHelper.writeException(t));
                    this.logger.error((Object)msg.toString(), (Throwable)e);
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Waiting for " + this.frequency + "ms before reconnecting. Failed attempt " + currentCount + " of " + this.retryCount));
                }
                try {
                    Thread.sleep(this.frequency);
                }
                catch (InterruptedException e1) {
                    throw new FatalConnectException(new Message(164, this.getClass().getName(), (Object)this.getDescription(connectable)), e, connectable);
                }
            }
        }
    }

    public synchronized void resetState() {
        ((AtomicInteger)count.get()).set(0);
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }
}

