/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleEvent;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.model.AbstractComponent;
import org.mule.providers.ReplyToHandler;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.transformer.UMOTransformer;

public class DefaultReplyToHandler
implements ReplyToHandler {
    private UMOTransformer transformer;
    private Map endpointCache = new ConcurrentHashMap();
    protected static Log logger = LogFactory.getLog((Class)DefaultReplyToHandler.class);

    public DefaultReplyToHandler(UMOTransformer transformer) {
        this.transformer = transformer;
    }

    public void processReplyTo(UMOEvent event, UMOMessage returnMessage, Object replyTo) throws UMOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sending reply to: " + returnMessage.getReplyTo()));
        }
        String replyToEndpoint = replyTo.toString();
        UMOEndpoint endpoint = this.getEndpoint(event, replyToEndpoint);
        if (this.transformer == null) {
            this.transformer = event.getEndpoint().getResponseTransformer();
        }
        if (this.transformer != null) {
            endpoint.setTransformer(this.transformer);
        }
        returnMessage.removeProperty("MULE_REPLYTO");
        MuleEvent replyToEvent = new MuleEvent(returnMessage, (UMOImmutableEndpoint)endpoint, event.getSession(), false);
        try {
            endpoint.getConnector().getDispatcher(endpoint).dispatch(replyToEvent);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("reply to sent: " + endpoint));
            }
            ((AbstractComponent)event.getComponent()).getStatistics().incSentReplyToEvent();
        }
        catch (Exception e) {
            throw new DispatchException(new Message(128, endpoint), replyToEvent.getMessage(), replyToEvent.getEndpoint(), e);
        }
    }

    protected UMOEndpoint getEndpoint(UMOEvent event, String endpointUri) throws UMOException {
        UMOEndpoint endpoint = (UMOEndpoint)this.endpointCache.get(endpointUri);
        if (endpoint == null && (endpoint = MuleManager.getInstance().lookupEndpoint(endpointUri)) == null) {
            MuleEndpointURI ep = new MuleEndpointURI(endpointUri);
            endpoint = MuleEndpoint.getOrCreateEndpointForUri(ep, "sender");
            this.endpointCache.put(endpointUri, endpoint);
        }
        return endpoint;
    }

    public UMOTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(UMOTransformer transformer) {
        this.transformer = transformer;
    }
}

