/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.umo.lifecycle.InitialisationException;

public abstract class AbstractJndiConnector
extends AbstractServiceEnabledConnector {
    protected String jndiInitialFactory;
    protected String jndiUrlPkgPrefixes;
    protected String jndiProviderUrl;
    protected Context jndiContext;
    protected Map jndiProviderProperties = null;

    protected void initJndiContext() throws InitialisationException {
        if (null == this.jndiContext) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (null != this.jndiInitialFactory) {
                props.put("java.naming.factory.initial", this.jndiInitialFactory);
            }
            if (this.jndiProviderUrl != null) {
                props.put("java.naming.provider.url", this.jndiProviderUrl);
            }
            if (this.jndiUrlPkgPrefixes != null) {
                props.put("java.naming.factory.url.pkgs", this.jndiUrlPkgPrefixes);
            }
            if (this.jndiProviderProperties != null) {
                props.putAll(this.jndiProviderProperties);
            }
            try {
                this.jndiContext = new InitialContext(props);
            }
            catch (NamingException e) {
                throw new InitialisationException(e, (Object)this);
            }
        }
    }

    public Context getJndiContext(String jndiProviderUrl) throws InitialisationException {
        try {
            this.setJndiProviderUrl(jndiProviderUrl);
            this.initJndiContext();
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(65, "AbstractJndiConnector"), e, this);
        }
        return this.jndiContext;
    }

    public Context getJndiContext() {
        return this.jndiContext;
    }

    public void setJndiContext(Context jndiContext) {
        this.jndiContext = jndiContext;
    }

    public void setJndiInitialFactory(String jndiInitialFactory) {
        this.jndiInitialFactory = jndiInitialFactory;
    }

    public String getJndiInitialFactory() {
        return this.jndiInitialFactory;
    }

    public void setJndiUrlPkgPrefixes(String jndiUrlPkgPrefixes) {
        this.jndiUrlPkgPrefixes = jndiUrlPkgPrefixes;
    }

    public String getJndiUrlPkgPrefixes() {
        return this.jndiUrlPkgPrefixes;
    }

    public String getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.jndiProviderUrl = jndiProviderUrl;
    }

    public Map getJndiProviderProperties() {
        return this.jndiProviderProperties;
    }

    public void setJndiProviderProperties(Map jndiProviderProperties) {
        this.jndiProviderProperties = jndiProviderProperties;
    }
}

