/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.i18n;

import java.io.Serializable;
import org.mule.config.i18n.Messages;

public class Message
implements Serializable {
    private static final long serialVersionUID = -6109760447384477924L;
    public static final int STATIC_ERROR_CODE = -1;
    private static final transient Object[] EMPTY_ARGS = new Object[0];
    private int code = 0;
    private Object[] args;
    private String message;
    private String bundle = "core";
    private Message nextMessage;

    private Message(String message) {
        this.code = -1;
        this.args = EMPTY_ARGS;
        this.message = message;
    }

    public Message(int code) {
        this.code = code;
        this.args = EMPTY_ARGS;
        this.message = Messages.get(code, this.args);
    }

    public Message(int code, Object[] args) {
        this.code = code;
        this.args = args;
        this.message = Messages.get(code, args);
    }

    public Message(int code, Object arg1) {
        this.code = code;
        if (arg1 == null) {
            arg1 = "null";
        }
        this.args = new Object[]{arg1};
        this.message = Messages.get(code, this.args);
    }

    public Message(int code, Object arg1, Object arg2) {
        this.code = code;
        if (arg1 == null) {
            arg1 = "null";
        }
        if (arg2 == null) {
            arg2 = "null";
        }
        this.args = new Object[]{arg1, arg2};
        this.message = Messages.get(code, this.args);
    }

    public Message(int code, Object arg1, Object arg2, Object arg3) {
        this.code = code;
        if (arg1 == null) {
            arg1 = "null";
        }
        if (arg2 == null) {
            arg2 = "null";
        }
        if (arg3 == null) {
            arg3 = "null";
        }
        this.args = new Object[]{arg1, arg2, arg3};
        this.message = Messages.get(code, this.args);
    }

    public Message(String bundle, int code) {
        this.code = code;
        this.args = EMPTY_ARGS;
        this.message = Messages.get(bundle, code, this.args);
        this.bundle = bundle;
    }

    public Message(String bundle, int code, Object[] args) {
        this.code = code;
        this.args = args;
        this.message = Messages.get(bundle, code, args);
        this.bundle = bundle;
    }

    public Message(String bundle, int code, Object arg1) {
        this.code = code;
        if (arg1 == null) {
            arg1 = "null";
        }
        this.args = new Object[]{arg1};
        this.message = Messages.get(bundle, code, this.args);
        this.bundle = bundle;
    }

    public Message(String bundle, int code, Object arg1, Object arg2) {
        this.code = code;
        if (arg1 == null) {
            arg1 = "null";
        }
        if (arg2 == null) {
            arg2 = "null";
        }
        this.args = new Object[]{arg1, arg2};
        this.message = Messages.get(bundle, code, this.args);
        this.bundle = bundle;
    }

    public Message(String bundle, int code, Object arg1, Object arg2, Object arg3) {
        this.code = code;
        if (arg1 == null) {
            arg1 = "null";
        }
        if (arg2 == null) {
            arg2 = "null";
        }
        if (arg3 == null) {
            arg3 = "null";
        }
        this.args = new Object[]{arg1, arg2, arg3};
        this.message = Messages.get(bundle, code, this.args);
        this.bundle = bundle;
    }

    public int getCode() {
        return this.code;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getMessage() {
        return this.message + (this.nextMessage != null ? ". " + this.nextMessage.getMessage() : "");
    }

    public Message setNextMessage(Message nextMessage) {
        this.nextMessage = nextMessage;
        return this;
    }

    public Message getNextMessage() {
        return this.nextMessage;
    }

    public String getBundle() {
        return this.bundle;
    }

    public static Message createStaticMessage(String message) {
        return new Message(message);
    }

    public String toString() {
        return this.getMessage();
    }
}

