/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.counters.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.mule.util.counters.Counter;
import org.mule.util.counters.CounterFactory;
import org.mule.util.counters.impl.AggregateCounter;

public abstract class AbstractCounter
implements Counter {
    private CounterFactory.Type type;
    private String name;
    private ArrayList aggregates = null;

    public AbstractCounter(String name, CounterFactory.Type type) {
        this.name = name;
        this.type = type;
    }

    public CounterFactory.Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public abstract double increment();

    public abstract double incrementBy(double var1);

    public abstract double decrement();

    public abstract void setRawValue(double var1);

    public abstract double nextValue();

    protected void addAggregate(AggregateCounter counter) {
        if (this.aggregates == null) {
            this.aggregates = new ArrayList();
        }
        this.aggregates.add(counter);
    }

    protected void propagate() {
        if (this.aggregates != null) {
            Iterator it = this.aggregates.iterator();
            while (it.hasNext()) {
                AggregateCounter agg = (AggregateCounter)it.next();
                agg.compute();
            }
        }
    }
}

