/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemUtils
extends org.apache.commons.lang.SystemUtils {
    protected static final transient Log logger = LogFactory.getLog((Class)SystemUtils.class);
    private static final String[] UNIX_ENV_PREFIXES = new String[]{"declare -", "typeset -"};

    public static synchronized Map getenv() {
        Map env = Collections.EMPTY_MAP;
        try {
            if (IS_JAVA_1_4) {
                env = SystemUtils.getenvJDK14();
            } else {
                Class target = System.class;
                Method envMethod = target.getMethod("getenv", ArrayUtils.EMPTY_CLASS_ARRAY);
                env = (Map)envMethod.invoke((Object)target, (Object[])null);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Could not access OS environment: ", (Throwable)ex);
        }
        return env;
    }

    private static Map getenvJDK14() throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        Process process = null;
        try {
            String line;
            String command;
            boolean isUnix = true;
            if (IS_OS_WINDOWS) {
                command = "cmd /c set";
                isUnix = false;
            } else {
                command = "env";
            }
            process = Runtime.getRuntime().exec(command);
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                for (int prefix = 0; prefix < UNIX_ENV_PREFIXES.length; ++prefix) {
                    if (!line.startsWith(UNIX_ENV_PREFIXES[prefix])) continue;
                    line = line.substring(UNIX_ENV_PREFIXES[prefix].length());
                }
                int index = -1;
                index = line.indexOf(61);
                if (index > -1) {
                    String key = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    if (isUnix && value.length() > 1 && (value.startsWith("\"") || value.startsWith("'"))) {
                        value = value.substring(1, value.length() - 1);
                    }
                    env.put(key, value);
                    continue;
                }
                env.put(line, "");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return env;
    }

    public static String getenv(String name) {
        return (String)SystemUtils.getenv().get(name);
    }

    public static boolean isSunJDK() {
        return JAVA_VM_VENDOR.toUpperCase().indexOf("SUN") != -1;
    }

    public static boolean isIbmJDK() {
        return JAVA_VM_VENDOR.toUpperCase().indexOf("IBM") != -1;
    }

    public static String getCommandLineOption(String option, String[] args) {
        int i;
        List<String> options = Arrays.asList(args);
        if (options.contains(option) && (i = options.indexOf(option)) < options.size() - 1) {
            return options.get(i + 1).toString();
        }
        return null;
    }
}

