/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import org.mule.MuleManager;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOConnector;

public class ObjectNameHelper {
    public static final String SEPARATOR = ".";
    public static final char HASH = '#';
    public static final String CONNECTOR_PREFIX = "_connector";
    public static final String ENDPOINT_PREFIX = "_endpoint";

    public static String getEndpointName(UMOImmutableEndpoint endpoint) {
        if (endpoint.getName() != null) {
            return ObjectNameHelper.replaceObjectNameChars(endpoint.getName());
        }
        String name = "_endpoint." + ObjectNameHelper.replaceObjectNameChars(endpoint.getEndpointURI().getAddress());
        int i = 0;
        while (MuleManager.getInstance().lookupEndpoint(name) != null) {
            name = "_endpoint." + ObjectNameHelper.replaceObjectNameChars(endpoint.getEndpointURI().getAddress()) + SEPARATOR + ++i;
        }
        return name;
    }

    public static String getConnectorName(UMOConnector connector) {
        if (connector.getName() != null && connector.getName().indexOf("#") == -1) {
            return ObjectNameHelper.replaceObjectNameChars(connector.getName());
        }
        int i = 0;
        String name = "_connector." + connector.getProtocol() + SEPARATOR + i;
        while (MuleManager.getInstance().lookupConnector(name) != null) {
            name = "_connector." + connector.getProtocol() + SEPARATOR + ++i;
        }
        return name;
    }

    public static String replaceObjectNameChars(String name) {
        String value = name.replaceAll("//", SEPARATOR);
        value = value.replaceAll("/", SEPARATOR);
        value = value.replaceAll("\\?", SEPARATOR);
        value = value.replaceAll("&", SEPARATOR);
        value = value.replaceAll(":", SEPARATOR);
        value = value.replaceAll("=", "-");
        return value;
    }
}

