/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.util.ClassUtils;

public class IOUtils
extends org.apache.commons.io.IOUtils {
    private static final Log logger = LogFactory.getLog((Class)IOUtils.class);

    public static String getResourceAsString(String resourceName, Class callingClass) throws IOException {
        InputStream is = IOUtils.getResourceAsStream(resourceName, callingClass);
        if (is != null) {
            return IOUtils.toString((InputStream)is);
        }
        throw new IOException("Unable to load resource " + resourceName);
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass) throws IOException {
        return IOUtils.getResourceAsStream(resourceName, callingClass, true, true);
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass, boolean tryAsFile, boolean tryAsUrl) throws IOException {
        URL url = IOUtils.getResourceAsUrl(resourceName, callingClass, tryAsFile);
        if (url == null && tryAsUrl) {
            try {
                url = new URL(resourceName);
            }
            catch (MalformedURLException e) {
                logger.debug((Object)("Unable to load resource as a URL: " + resourceName));
            }
        }
        if (url == null) {
            return null;
        }
        return url.openStream();
    }

    public static URL getResourceAsUrl(String resourceName, Class callingClass) {
        return IOUtils.getResourceAsUrl(resourceName, callingClass, true);
    }

    public static URL getResourceAsUrl(final String resourceName, final Class callingClass, boolean tryAsFile) {
        if (resourceName == null) {
            throw new IllegalArgumentException(new Message(45, "Resource name").getMessage());
        }
        URL url = null;
        if (tryAsFile) {
            try {
                File file = new File(resourceName);
                if (file.exists()) {
                    url = file.getAbsoluteFile().toURL();
                } else {
                    logger.debug((Object)("Unable to load resource from the file system: " + file.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                logger.debug((Object)("Unable to load resource from the file system: " + e.getMessage()));
            }
        }
        if (url == null) {
            try {
                url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ClassUtils.getResource(resourceName, callingClass);
                    }
                });
                if (url == null) {
                    logger.debug((Object)"Unable to load resource from the classpath");
                }
            }
            catch (Exception e) {
                logger.debug((Object)("Unable to load resource from the classpath: " + e.getMessage()));
            }
        }
        return url;
    }
}

