/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOTransaction;

public class TransactionCoordination {
    protected static final transient Log logger = LogFactory.getLog((Class)TransactionCoordination.class);
    private static TransactionCoordination instance;
    private int txCounter = 0;
    private ThreadLocal transactions = new ThreadLocal();

    private TransactionCoordination() {
    }

    public static TransactionCoordination getInstance() {
        if (instance == null) {
            instance = new TransactionCoordination();
        }
        return instance;
    }

    public static void setInstance(TransactionCoordination txSync) {
        if (instance != null && TransactionCoordination.instance.txCounter != 0) {
            throw new IllegalStateException("there are currently " + TransactionCoordination.instance.txCounter + "transactions associated with this manager, cannot replace the manager");
        }
        instance = txSync;
    }

    public UMOTransaction getTransaction() {
        return (UMOTransaction)this.transactions.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindTransaction(UMOTransaction transaction) throws TransactionException {
        try {
            UMOTransaction oldTx = (UMOTransaction)this.transactions.get();
            if (oldTx != null && !oldTx.equals(transaction)) {
                throw new IllegalTransactionStateException(new Message(107));
            }
        }
        finally {
            this.transactions.set(null);
            this.decrementCounter();
        }
    }

    public void bindTransaction(UMOTransaction transaction) throws TransactionException {
        UMOTransaction oldTx = (UMOTransaction)this.transactions.get();
        if (oldTx != null) {
            throw new IllegalTransactionStateException(new Message(108));
        }
        this.transactions.set(transaction);
        this.incrementCounter();
        logger.debug((Object)("Binding new transaction (" + this.txCounter + ")"));
    }

    private synchronized void decrementCounter() {
        if (this.txCounter > 0) {
            --this.txCounter;
        }
    }

    private synchronized void incrementCounter() {
        ++this.txCounter;
    }
}

