/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutePathNotFoundException;
import org.mule.umo.routing.RoutingException;

public class ChainingRouter
extends FilteringOutboundRouter {
    protected static transient Log logger = LogFactory.getLog((Class)ChainingRouter.class);

    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        UMOMessage resultToReturn = null;
        int endpointsCount = this.endpoints.size();
        if (this.endpoints == null || endpointsCount == 0) {
            throw new RoutePathNotFoundException(new Message(89), message, null);
        }
        logger.debug((Object)("About to chain " + endpointsCount + " endpoints."));
        UMOEndpoint endpoint = null;
        try {
            UMOMessage intermediaryResult = message;
            for (int i = 0; i < endpointsCount; ++i) {
                boolean lastEndpointInChain;
                endpoint = this.getEndpoint(i, intermediaryResult);
                boolean bl = lastEndpointInChain = i == endpointsCount - 1;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending Chained message '" + i + "': " + (intermediaryResult == null ? "null" : intermediaryResult.toString())));
                }
                if (!lastEndpointInChain) {
                    UMOMessage tempResult = this.send(session, intermediaryResult, endpoint);
                    if (tempResult != null && intermediaryResult != null) {
                        tempResult.setCorrelationId(intermediaryResult.getCorrelationId());
                        tempResult.setCorrelationSequence(intermediaryResult.getCorrelationSequence());
                        tempResult.setCorrelationGroupSize(intermediaryResult.getCorrelationGroupSize());
                        tempResult.setReplyTo(intermediaryResult.getReplyTo());
                    }
                    intermediaryResult = tempResult;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received Chain result '" + i + "': " + (intermediaryResult != null ? intermediaryResult.toString() : "null")));
                    }
                    if (intermediaryResult != null) continue;
                    logger.warn((Object)("Chaining router cannot process any further endpoints. There was no result returned from endpoint invocation: " + endpoint));
                    break;
                }
                if (synchronous) {
                    resultToReturn = this.send(session, intermediaryResult, endpoint);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Received final Chain result '" + i + "': " + (resultToReturn == null ? "null" : resultToReturn.toString())));
                    continue;
                }
                resultToReturn = null;
                this.dispatch(session, intermediaryResult, endpoint);
            }
        }
        catch (UMOException e) {
            throw new CouldNotRouteOutboundMessageException(message, endpoint, (Throwable)e);
        }
        return resultToReturn;
    }

    public void addEndpoint(UMOEndpoint endpoint) {
        if (!endpoint.isRemoteSync()) {
            logger.debug((Object)("Endpoint: " + endpoint.getEndpointURI() + " registered on chaining router needs to be RemoteSync enabled. Setting this property now"));
            endpoint.setRemoteSync(true);
        }
        super.addEndpoint(endpoint);
    }
}

