/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.mule.umo.UMOEvent;

public class EventGroup
implements Serializable {
    private static final long serialVersionUID = -7337182983687406403L;
    private final Object groupId;
    private final List events;
    private final long created = System.currentTimeMillis();
    private final int expectedSize;

    public EventGroup(Object groupId) {
        this(groupId, -1);
    }

    public EventGroup(Object groupId, int expectedSize) {
        this.events = new CopyOnWriteArrayList();
        this.expectedSize = expectedSize;
        this.groupId = groupId;
    }

    public Object getGroupId() {
        return this.groupId;
    }

    public Iterator iterator() {
        return this.events.iterator();
    }

    public void addEvent(UMOEvent event) {
        this.events.add(event);
    }

    public void removeEvent(UMOEvent event) {
        this.events.remove(event);
    }

    public long getCreated() {
        return this.created;
    }

    public int size() {
        return this.events.size();
    }

    public int expectedSize() {
        return this.expectedSize;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Event Group Id=").append(this.groupId);
        buf.append(", expected size=").append(this.expectedSize);
        buf.append(", current events (").append(this.events.size()).append(")");
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            UMOEvent event = (UMOEvent)iterator.next();
            buf.append(", ").append(event.getMessage().getUniqueId());
        }
        return buf.toString();
    }
}

