/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public abstract class PollingMessageReceiver
extends AbstractMessageReceiver
implements Work {
    public static final long DEFAULT_POLL_FREQUENCY = 1000L;
    public static final long STARTUP_DELAY = 1000L;
    protected long frequency = 1000L;

    public PollingMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, Long frequency) throws InitialisationException {
        super(connector, component, endpoint);
        this.frequency = frequency;
    }

    public void doStart() throws UMOException {
        try {
            this.getWorkManager().scheduleWork(this, Long.MAX_VALUE, null, this.connector);
        }
        catch (WorkException e) {
            this.stopped.set(true);
            throw new InitialisationException(new Message(151), e, this);
        }
    }

    public void run() {
        try {
            Thread.sleep(1000L);
            while (!this.stopped.get()) {
                this.connected.whenTrue(null);
                try {
                    this.poll();
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Exception e) {
                    this.handleException(e);
                }
                Thread.sleep(this.frequency);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void release() {
        this.stop();
    }

    public void setFrequency(long l) {
        this.frequency = l <= 0L ? 1000L : l;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public abstract void poll() throws Exception;
}

